% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{orbi_flag_weak_isotopocules}
\alias{orbi_flag_weak_isotopocules}
\title{Flag weak isotopocules}
\usage{
orbi_flag_weak_isotopocules(dataset, min_percent = 100)
}
\arguments{
\item{dataset}{A simplified IsoX data frame to be processed}

\item{min_percent}{A number between 0 and 100 (inclusive). Isotopocule must be observed in at least this percentage of scans (please note: the percentage
is defined relative to the most commonly observed isotopocule of each compound). The default is 100, the most stringent condition to ensure reliable
isotpocule coverage and ratio calculations across data blocks. If you lower the default, be mindful of potential misinterprations from using isotopotcules
that are very close to their detection limit within a datablock. For continuous flow operations it may be necessary to make data blocks smaller using
\code{\link[=orbi_define_block_for_flow_injection]{orbi_define_block_for_flow_injection()}} and \code{\link[=orbi_adjust_block]{orbi_adjust_block()}}.}
}
\value{
same object as provided in \code{dataset} with new column \code{is_weak_isotopocule} that flags weak isotopocules.
}
\description{
This function flags isotopocules that are not detected in a minimum of \code{min_percent} of scans that then can be easily visualized with \code{\link[=orbi_plot_isotopocule_coverage]{orbi_plot_isotopocule_coverage()}}.
It evaluates weak isotopocules within each "uidx", "filename", "block", "segment" and "injection" (for those of the columns that exist),
in addition to any groupings already defined before calling this function using dplyr's \code{group_by()}. It restores the original groupings in the returned data.
}
\examples{
fpath <- system.file("extdata", "testfile_flow.isox", package = "isoorbi")
df <- orbi_read_isox(file = fpath) |>
      orbi_simplify_isox() |>
      orbi_flag_weak_isotopocules(min_percent = 100)

}
