% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_image.R
\docType{methods}
\name{ternary_tile}
\alias{ternary_tile}
\alias{tile_bin}
\alias{tile_bin-method}
\alias{tile_density}
\alias{tile_density-method}
\alias{tile_interpolate}
\alias{tile_interpolate-method}
\alias{tile_bin,numeric,numeric,numeric-method}
\alias{tile_bin,ANY,missing,missing-method}
\alias{tile_density,numeric,numeric,numeric-method}
\alias{tile_density,ANY,missing,missing-method}
\alias{tile_interpolate,numeric,numeric,numeric-method}
\alias{tile_interpolate,ANY,missing,missing-method}
\title{Ternary Tiles}
\usage{
tile_bin(x, y, z, ...)

tile_density(x, y, z, ...)

tile_interpolate(x, y, z, ...)

\S4method{tile_bin}{numeric,numeric,numeric}(x, y, z)

\S4method{tile_bin}{ANY,missing,missing}(x)

\S4method{tile_density}{numeric,numeric,numeric}(x, y, z)

\S4method{tile_density}{ANY,missing,missing}(x)

\S4method{tile_interpolate}{numeric,numeric,numeric}(x, y, z, value, method = "linear", ...)

\S4method{tile_interpolate}{ANY,missing,missing}(x, value, method = "linear", ...)
}
\arguments{
\item{x, y, z}{A \code{\link{numeric}} vector giving the x, y and z ternary coordinates
of a set of points. If \code{y} and \code{z} are missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xyz.coords]{grDevices::xyz.coords()}}).}

\item{...}{Further parameters to be passed to internal methods.}

\item{value}{A \code{\link{numeric}} vector giving the values to be interpolated.}

\item{method}{A \code{\link{character}} string: specifying the method for interpolation
(see \code{\link[interp:interp]{interp::interp()}}).}
}
\value{
A \code{\link{function}} that takes three \code{\link{numeric}} vector as arguments and returns
a \code{numeric} vector.
}
\description{
Compute tile values.
}
\examples{
## Data from Aitchison 1986
## Bin
f <- tile_bin(lava)
ternary_plot(NULL)
ternary_image(f = f, n = 12)

## Custom color palette
pal <- function(x) {
  x <- (x - min(x)) / (max(x) - min(x)) # Rescale to [0,1]
  YlOrBr <- c("#FFFFD4", "#FED98E", "#FE9929", "#D95F0E", "#993404")
  RGB <- grDevices::colorRamp(YlOrBr)(x)
  grDevices::rgb(RGB, maxColorValue = 255)
}

ternary_plot(NULL)
ternary_image(f = f, n = 12, palette = pal)

## Density
f <- tile_density(lava)
ternary_plot(NULL)
ternary_image(f = f, n = 12, palette = pal)

if (requireNamespace("interp", quietly = TRUE)) {
  ## Interpolation
  f <- tile_interpolate(arctic, value = arctic$depth)
  ternary_plot(NULL)
  ternary_image(f = f, n = 24, palette = pal)
  ternary_points(arctic, col = "red", pch = 16)
}
}
\seealso{
\code{\link[=ternary_image]{ternary_image()}}
}
\author{
N. Frerebeau
}
\concept{tiles}
