% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_conservation_status.R
\name{get_conservation_status}
\alias{get_conservation_status}
\title{Get Conservation Status of Species}
\usage{
get_conservation_status(splist)
}
\arguments{
\item{splist}{A character vector of species names to search for in the iucn_data dataset.}
}
\value{
A data.table with species names and their corresponding conservation status or "no match found".
}
\description{
This function retrieves the conservation status of species from the iucn_data dataset.
It is vectorized to handle multiple species names and optimized using data.table for performance.
}
\examples{
\donttest{
species <- c("Panthera uncia", "Cedrela odorata")
result <- get_conservation_status(splist = species)
print(result)
}
}
