% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba.r
\name{log2signed}
\alias{log2signed}
\title{log2 transformation with directionality}
\usage{
log2signed(x, offset = 1, base = 2, ...)
}
\arguments{
\item{x}{\code{numeric} vector}

\item{offset}{\code{numeric} value added to the absolute values
of \code{x} prior to applying the log transformation.}

\item{base}{\code{numeric} value indicating the logarithmic base,
by default \code{2} in order to apply \code{base::log2()}.}

\item{...}{additional arguments are ignored.}
}
\value{
numeric vector of log-transformed magnitudes.
}
\description{
log2 transformation with directionality
}
\details{
This function applies a log2 transformation but maintains
the sign of the input data, allowing for log2 transformation
of negative values.

The method applies an offset to the absolute value \code{abs(x)},
in order to handle values between zero and 1, then applies
log2 transformation, then multiplies by the original sign
from \code{sign(x)}.

The argument \code{offset} is used to adjust values, for example
\code{offset=1} will apply log2 transformation \code{log2(1 + x)},
except using the absolute value of \code{x}. This method allows
for positive and negative input data to contain values
between 0 and 1, and between -1 and 0.

This function could be described as applying
a log2 transformation of the "magnitude" of values in \code{x},
while maintaining the positive or negative directionality.

If any \code{abs(x)} are less than \code{offset} this function will
raise an error.
}
\examples{
x <- c(-100:100)/10;
log2signed(x);
plot(x=x, y=log2signed(x), xlab="x", ylab="log2signed(x)")

}
\seealso{
Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{colNum2excelName}()},
\code{\link{color_dither}()},
\code{\link{exp2signed}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{kable_coloring}()},
\code{\link{lldf}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{printDebug}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()},
\code{\link{setPrompt}()}
}
\concept{jam practical functions}
