% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-axis.R
\name{sqrtAxis}
\alias{sqrtAxis}
\title{Determine square root axis tick mark positions}
\usage{
sqrtAxis(
  side = 1,
  x = NULL,
  pretty.n = 10,
  u5.bias = 1,
  big.mark = ",",
  plot = TRUE,
  las = 2,
  cex.axis = 0.6,
  ...
)
}
\arguments{
\item{side}{\code{integer} value indicating the axis position, as used
by \code{graphics::axis()}, 1=bottom, 2=left, 3=top, 4=right.
Note that when \code{x} is supplied, the numeric range is defined
using values in \code{x} and not the axis side.}

\item{x}{optional \code{numeric} vector representing the numeric range
to be labeled. When supplied, the numeric range of \code{x} is used
and not the axis side.}

\item{pretty.n}{\code{numeric} value indicating the number of desired
tick marks, passed to \code{pretty()}.}

\item{u5.bias}{\code{numeric} value passed to \code{pretty()} to influence the
frequency of intermediate tick marks.}

\item{big.mark}{\code{character} value passed to \code{format()} which helps
visually distinguish numbers larger than 1000.}

\item{plot}{\code{logical} indicating whether to plot the axis tick
marks and labels.}

\item{las, cex.axis}{\code{numeric} values passed to \code{graphics::axis()}
when drawing the axis. The custom default \code{las=2} plots labels rotated
perpendicular to the axis.}

\item{...}{additional parameters are passed to \code{pretty()}, and to
\code{graphics::axis()} when \code{plot=TRUE}.}
}
\value{
invisible \code{numeric} vector with axis positions, named
by normal space numeric labels. The primary use is to
add numeric axis tick marks and labels.
}
\description{
Determine square root axis tick mark positions, including positive
and negative range values.
}
\details{
This function calculates positions for tick marks for data
that has been transformed with \code{sqrt()}, specifically a directional
transformation like \code{sqrt(abs(x)) * sign(x)}.

If \code{x} is supplied, it is used to define the numeric range, otherwise
the observed range is taken based upon \code{side}. If neither \code{x} nor \code{side}
is supplied, or if the numeric range is empty or zero width,
it returns \code{NULL}.

The main goal of this function is to provide reasonably placed
tick marks using integer values.
}
\examples{
plot(-3:3*10, -3:3*10, xaxt="n")
x <- sqrtAxis(1)
abline(v=x, col="grey", lty="dotted")
abline(h=pretty(par("usr")[3:4]), col="grey", lty="dotted")

# slightly different label placement with u5.bias=0
plot(-3:3*10, -3:3*10, xaxt="n")
x <- sqrtAxis(1, u5.bias=0)
abline(v=x, col="grey", lty="dotted")
abline(h=pretty(par("usr")[3:4]), col="grey", lty="dotted")

}
\seealso{
Other jam plot functions: 
\code{\link{adjustAxisLabelMargins}()},
\code{\link{coordPresets}()},
\code{\link{decideMfrow}()},
\code{\link{drawLabels}()},
\code{\link{getPlotAspect}()},
\code{\link{groupedAxis}()},
\code{\link{imageByColors}()},
\code{\link{imageDefault}()},
\code{\link{minorLogTicksAxis}()},
\code{\link{nullPlot}()},
\code{\link{plotPolygonDensity}()},
\code{\link{plotRidges}()},
\code{\link{plotSmoothScatter}()},
\code{\link{shadowText}()},
\code{\link{shadowText_options}()},
\code{\link{showColors}()},
\code{\link{usrBox}()}
}
\concept{jam plot functions}
