% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/job_class.r
\name{job_class}
\alias{job_class}
\title{Define an R Expression (R6 Class)}
\description{
The \code{\link[=job_class]{job}} object encapsulates an expression and its evaluation
parameters. It also provides a way to check for and retrieve the result.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{expr}}{R expression that will be run by this \code{\link[=job_class]{job}}.}

\item{\code{vars}}{Get or set - List of variables that will be placed into the expression's
environment before evaluation.}

\item{\code{reformat}}{Get or set - \verb{function (job)} for defining \verb{<job>$result}.}

\item{\code{signal}}{Get or set - Conditions to signal.}

\item{\code{cpus}}{Get or set - Number of CPUs to reserve for evaluating \code{expr}.}

\item{\code{timeout}}{Get or set - Time limits to apply to this \code{\link[=job_class]{job}}.}

\item{\code{proxy}}{Get or set - \code{\link[=job_class]{job}} to proxy in place of running \code{expr}.}

\item{\code{state}}{Get or set - The \code{\link[=job_class]{job's}} state: \code{'created'}, \code{'submitted'},
\code{'queued'}, \code{'dispatched'}, \code{'starting'}, \code{'running'}, or \code{'done'}.
\emph{Assigning to \verb{<job>$state} will trigger callback hooks.}}

\item{\code{output}}{Get or set - \code{\link[=job_class]{job's}} raw output.
\emph{Assigning to \verb{<job>$output} will change the \code{\link[=job_class]{job's}} state
to \code{'done'}.}}

\item{\code{jobqueue}}{The \code{\link[=jobqueue_class]{jobqueue}} that this \code{\link[=job_class]{job}} belongs
to.}

\item{\code{worker}}{The \code{\link[=worker_class]{worker}} that this \code{\link[=job_class]{job}} belongs to.}

\item{\code{result}}{Result of \code{expr}. Will block until \code{\link[=job_class]{job}} is finished.}

\item{\code{hooks}}{Currently registered callback hooks as a named list of functions.
Set new hooks with \verb{<job>$on()}.}

\item{\code{is_done}}{\code{TRUE} or \code{FALSE} depending on if the \code{\link[=job_class]{job's}} result is
ready.}

\item{\code{uid}}{A short string, e.g. \code{'J16'}, that uniquely identifies this
\code{\link[=job_class]{job}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-job-new}{\code{job_class$new()}}
\item \href{#method-job-print}{\code{job_class$print()}}
\item \href{#method-job-on}{\code{job_class$on()}}
\item \href{#method-job-wait}{\code{job_class$wait()}}
\item \href{#method-job-stop}{\code{job_class$stop()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-job-new"></a>}}
\if{latex}{\out{\hypertarget{method-job-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link[=job_class]{job}} object defining how to run an expression on
a background \code{\link[=worker_class]{worker}} process.

\emph{Typically you won't need to call \code{job_class$new()}. Instead, create a
\code{\link[=jobqueue_class]{jobqueue}} and use \verb{<jobqueue>$run()} to generate
\code{\link[=job_class]{job}} objects.}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{job_class$new(
  expr,
  vars = NULL,
  timeout = NULL,
  hooks = NULL,
  reformat = NULL,
  signal = FALSE,
  cpus = 1L,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expr}}{A call or R expression wrapped in curly braces to evaluate on a
\code{\link[=worker_class]{worker}}. Will have access to any variables defined
by \code{vars}, as well as the \code{\link[=worker_class]{worker's}} \code{globals},
\code{packages}, and \code{init} configuration. See \code{vignette('eval')}.}

\item{\code{vars}}{A named list of variables to make available to \code{expr} during
evaluation. Alternatively, an object that can be coerced to a named
list with \code{as.list()}, e.g. named vector, data.frame, or environment.
Or a \verb{function (job)} that returns such an object.}

\item{\code{timeout}}{A named numeric vector indicating the maximum number of
seconds allowed for each state the \code{\link[=job_class]{job}} passes through,
or 'total' to apply a single timeout from 'submitted' to 'done'. Or a
\verb{function (job)} that returns the same. Example:
\code{timeout = c(total = 2.5, running = 1)}. See \code{vignette('stops')}.}

\item{\code{hooks}}{A named list of functions to run when the \code{\link[=job_class]{job}}
state changes, of the form
\code{hooks = list(created = function (worker) {...})}. Or a
\verb{function (job)} that returns the same. Names of
\code{\link[=worker_class]{worker}} hooks are typically \code{'created'},
\code{'submitted'}, \code{'queued'}, \code{'dispatched'}, \code{'starting'}, \code{'running'},
\code{'done'}, or \code{'*'} (duplicates okay). See \code{vignette('hooks')}.}

\item{\code{reformat}}{Set \verb{reformat = function (job)} to define what
\verb{<job>$result} should return. The default, \code{reformat = NULL} passes
\verb{<job>$output} to \verb{<job>$result} unchanged.
See \code{vignette('results')}.}

\item{\code{signal}}{Should calling \verb{<job>$result} signal on condition objects?
When \code{FALSE}, \verb{<job>$result} will return the object without
taking additional action. Setting to \code{TRUE} or a character vector of
condition classes, e.g. \code{c('interrupt', 'error', 'warning')}, will
cause the equivalent of \verb{stop(<condition>)} to be called when those
conditions are produced. Alternatively, a \verb{function (job)} that
returns \code{TRUE} or \code{FALSE}. See \code{vignette('results')}.}

\item{\code{cpus}}{How many CPU cores to reserve for this \code{\link[=job_class]{job}}. Or a
\verb{function (job)} that returns the same. Used to limit the number of
\code{\link[=job_class]{jobs}} running simultaneously to respect
\verb{<jobqueue>$max_cpus}. Does not prevent a \code{\link[=job_class]{job}} from
using more CPUs than reserved.}

\item{\code{...}}{Arbitrary named values to add to the returned \code{\link[=job_class]{job}}
object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link[=job_class]{job}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-job-print"></a>}}
\if{latex}{\out{\hypertarget{method-job-print}{}}}
\subsection{Method \code{print()}}{
Print method for a \code{\link[=job_class]{job}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{job_class$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments are not used currently.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{\link[=job_class]{job}}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-job-on"></a>}}
\if{latex}{\out{\hypertarget{method-job-on}{}}}
\subsection{Method \code{on()}}{
Attach a callback function to execute when the \code{\link[=job_class]{job}} enters
\code{state}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{job_class$on(state, func)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{The name of a \code{\link[=job_class]{job}} state. Typically one of:
\itemize{
\item \code{'*'} -          Every time the state changes.
\item \code{'.next'} -      Only one time, the next time the state changes.
\item \code{'created'} -    After \code{job_class$new()} initialization.
\item \code{'submitted'} -  After \verb{<job>$jobqueue} is assigned.
\item \code{'queued'} -     After \code{stop_id} and \code{copy_id} are resolved.
\item \code{'dispatched'} - After \verb{<job>$worker} is assigned.
\item \code{'starting'} -   Before evaluation begins.
\item \code{'running'} -    After evaluation begins.
\item \code{'done'} -       After \verb{<job>$output} is assigned.
}

Custom states can also be specified.}

\item{\code{func}}{A function that accepts a \code{\link[=job_class]{job}} object as input.
You can call \verb{<job>$stop()} or edit \verb{<job>$} values and the changes
will be persisted (since \code{\link[=job_class]{jobs}} are reference class
objects). You can also edit/stop other queued \code{\link[=job_class]{jobs}} by
modifying the \code{\link[=job_class]{jobs}} in \verb{<job>$jobqueue$jobs}. Return
value is ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A function that when called removes this callback from the
\code{\link[=job_class]{job}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-job-wait"></a>}}
\if{latex}{\out{\hypertarget{method-job-wait}{}}}
\subsection{Method \code{wait()}}{
Blocks until the \code{\link[=job_class]{job}} enters the given state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{job_class$wait(state = "done", timeout = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{The name of a \code{\link[=job_class]{job}} state. Typically one of:
\itemize{
\item \code{'*'} -          Every time the state changes.
\item \code{'.next'} -      Only one time, the next time the state changes.
\item \code{'created'} -    After \code{job_class$new()} initialization.
\item \code{'submitted'} -  After \verb{<job>$jobqueue} is assigned.
\item \code{'queued'} -     After \code{stop_id} and \code{copy_id} are resolved.
\item \code{'dispatched'} - After \verb{<job>$worker} is assigned.
\item \code{'starting'} -   Before evaluation begins.
\item \code{'running'} -    After evaluation begins.
\item \code{'done'} -       After \verb{<job>$output} is assigned.
}

Custom states can also be specified.}

\item{\code{timeout}}{Stop the \code{\link[=job_class]{job}} if it takes longer than this
number of seconds, or \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{\link[=job_class]{job}}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-job-stop"></a>}}
\if{latex}{\out{\hypertarget{method-job-stop}{}}}
\subsection{Method \code{stop()}}{
Stop this \code{\link[=job_class]{job}}. If the \code{\link[=job_class]{job}} is running, its
\code{\link[=worker_class]{worker}} will be restarted.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{job_class$stop(reason = "job stopped by user", cls = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reason}}{A message to include in the 'interrupt' condition object that
will be returned as the \code{\link[=job_class]{job's}} result. Or a condition
object.}

\item{\code{cls}}{Character vector of additional classes to prepend to
\code{c('interrupt', 'condition')}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{\link[=job_class]{job}}, invisibly.
}
}
}
