% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/claim.R
\name{jwt_claim}
\alias{jwt_claim}
\title{Generate claim}
\usage{
jwt_claim(
  iss = NULL,
  sub = NULL,
  aud = NULL,
  exp = NULL,
  nbf = NULL,
  iat = Sys.time(),
  jti = NULL,
  ...
)
}
\arguments{
\item{iss}{(Issuer) Claim, should be rfc7519 'StringOrURI' value}

\item{sub}{(Subject) Claim, should be rfc7519 'StringOrURI' value}

\item{aud}{(Audience) Claim, should contain one or rfc7519 'StringOrURI' values}

\item{exp}{(Expiration Time) Claim, should be rfc7519 'NumericDate' value; R
\code{POSIXct} values are automatically coerced.}

\item{nbf}{(Not Before) Claim, should be rfc7519 'NumericDate' value; R
\code{POSIXct} values are automatically coerced.}

\item{iat}{(Issued At) Claim, should be rfc7519 'NumericDate' value; R
\code{POSIXct} values are automatically coerced.}

\item{jti}{(JWT ID) Claim, optional unique identifier for the JWT}

\item{...}{additional custom claims to include}
}
\description{
Helper function to create a named list used as the claim of a JWT payload.
See \url{https://datatracker.ietf.org/doc/html/rfc7519#section-4.1} for details.
}
