% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{jot}
\alias{jot}
\alias{write_jot}
\title{Jot Down a Note}
\usage{
jot(
  note,
  name,
  overwrite = FALSE,
  user = get_jot_user(),
  time = get_sys_time(),
  pad = jot_active()
)

write_jot(
  note,
  name,
  overwrite = FALSE,
  user = get_jot_user(),
  time = get_sys_time(),
  pad = jot_active()
)
}
\arguments{
\item{note}{data to save. required.}

\item{name}{character, name of data. required.}

\item{overwrite}{logical, default is FALSE. If a note of the same name exists, should it be overwritten?}

\item{user}{name of user. default is \code{get_jot_user()}.}

\item{time}{system time. default is \code{get_sys_time()}.}

\item{pad}{path to file of pad to write to. default is \code{jot_active()}.}
}
\value{
path to pad, invisibly
}
\description{
Jot Down a Note
}
\examples{
tf <- tempfile()
jot_new_pad(tf)
jot_activate(tf)
jot(3, 'example')
}
\concept{write}
