% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{random_shuffle}
\alias{random_shuffle}
\title{Shuffle the elements of a tensor uniformly at random along an axis.}
\usage{
random_shuffle(x, axis = 1L, seed = NULL)
}
\arguments{
\item{x}{The tensor to be shuffled.}

\item{axis}{An integer specifying the axis along which to shuffle. Defaults to
\code{0}.}

\item{seed}{Optional R integer or instance of
\code{\link[=random_seed_generator]{random_seed_generator()}}.
By default, the \code{seed} argument is \code{NULL}, and an internal global
\code{\link[=random_seed_generator]{random_seed_generator()}} is used. The \code{seed} argument can be
used to ensure deterministic (repeatable) random number generation.
Note that passing an integer as the \code{seed} value will produce the
same random values for each call. To generate different random
values for repeated calls, an instance of
\code{\link[=random_seed_generator]{random_seed_generator()}} must be provided as the \code{seed} value.

Remark concerning the JAX backend: When tracing functions with the
JAX backend the global \code{\link[=random_seed_generator]{random_seed_generator()}} is not
supported. Therefore, during tracing the default value \code{seed=NULL}
will produce an error, and a \code{seed} argument must be provided.}
}
\value{
A tensor, a copy of \code{x} with the \code{axis} axis shuffled.
}
\description{
Shuffle the elements of a tensor uniformly at random along an axis.
}
\seealso{
Other random: \cr
\code{\link{random_beta}()} \cr
\code{\link{random_binomial}()} \cr
\code{\link{random_categorical}()} \cr
\code{\link{random_dropout}()} \cr
\code{\link{random_gamma}()} \cr
\code{\link{random_integer}()} \cr
\code{\link{random_normal}()} \cr
\code{\link{random_seed_generator}()} \cr
\code{\link{random_truncated_normal}()} \cr
\code{\link{random_uniform}()} \cr
}
\concept{random}
