% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3d.smooths.r
\name{kernel.smooth.in.space.and.time.with.margins}
\alias{kernel.smooth.in.space.and.time.with.margins}
\title{Kernel smooth data in space and time, returning specific error margins at each point}
\usage{
kernel.smooth.in.space.and.time.with.margins(
  dataset,
  dependent.variable = "dependent.variable",
  x = "x",
  y = "y",
  time = "year",
  weight = "weight",
  normalise.by,
  data.type = "factor",
  alpha = 0.05,
  margin = 0.1,
  kernel.function = gaussian.kernel,
  adaptive.spatial.bw = TRUE,
  temporal.bandwidth,
  measure.points,
  measure.times,
  projection = NA,
  explicit = TRUE
)
}
\arguments{
\item{dataset}{The dataset to be smoothed as a data.frame.}

\item{dependent.variable}{String name of the single column in dataset with the factor dependent variable (if data.type=="factor") or a vector of column names with numeric counts (if data.type=="count") (defaults to "dependent.variable").}

\item{x}{String name of column containing numeric x co-ordinate (defaults to "x").}

\item{y}{String name of column containing numeric y co-ordinate (defaults to "y").}

\item{time}{String name of the column in dataset with the time variable (defaults to "year").}

\item{weight}{String name of column in the dataset with numeric weights (defaults to "weight").}

\item{normalise.by}{String name of column by which data should be normalised (typically factor with document, speaker or writer ids).}

\item{data.type}{The type of the dependent variable as a string: either "factor", if each row is a token, or "count", if each row is a document, speaker or writer with token counts in separate columns (defaults to "factor").}

\item{alpha}{Numeric alpha for calculating error margins (defaults to 0.05).}

\item{margin}{Numeric desired error margin for calculating spatial bandwidths.}

\item{kernel.function}{The kernel function, one of gaussian.kernel, gaussian.square.kernel, triangular.kernel, square.kernel, or a custom function (defaults to gaussian.kernel).}

\item{adaptive.spatial.bw}{Boolean indicating whether the spatial bandwidth is adaptive (set to achieve margin at every point) or static (set to the average of bandwidths needed to achieve margin at every point).}

\item{temporal.bandwidth}{Numeric bandwidth of the (gaussian) temporal kernel.}

\item{measure.points}{A data.frame of spatial points at which estimates are to be made, with two columns with the same names as x,y in dataset; if not supplied, estimates are at the same locations as dataset.}

\item{measure.times}{A numeric vector of specific times at which to make estimates; if not given, will default to seq(from=min(time),to=max(time),length.out=5).}

\item{projection}{The spatial projection as a proj4 string - if given, data will be projected before smoothing and results will be deprojected before returning.}

\item{explicit}{If TRUE, progress will be reported with a progress bar (defaults to TRUE).}
}
\value{
A list containing the parameters and a data.frame with the smoothed estimates.
}
\description{
This function performs kernel smoothing on a dataset in time and space. A static temporal kernel is applied first, and then an (optionally) adaptive spatial kernel on this weighted data. Note that this is the same as kernel.smooth.in.space.and.time() except that it returns specific error margins with every estimate and is \emph{much} slower.
}
\examples{
\donttest{n=200;
synthesised.data<-data.frame(x=stats::runif(n),y=stats::runif(n),
    year=stats::runif(n,0,sqrt(2)));
synthesised.data$dependent.variable<-unlist(lapply(1:nrow(synthesised.data),
    function(X){
    stats::dist(as.matrix(synthesised.data[c(1,X),1:2]),method =
        "euclidean")<synthesised.data$year[X];
}));
result<-kernelPhil::kernel.smooth.in.space.and.time.with.margins(dataset =
    synthesised.data,temporal.bandwidth = 0.2,measure.times =
    seq(from=0.15,to=0.85,length.out=2),alpha=0.4,margin=0.2);
gridExtra::grid.arrange(ggplot2::ggplot(result$results[[1]],
    ggplot2::aes(x=x,y=y,colour=relative_density_TRUE))+
    ggplot2::geom_point(),ggplot2::ggplot(result$results[[2]],
    ggplot2::aes(x=x,y=y,colour=relative_density_TRUE))+
    ggplot2::geom_point())}
}
