% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_measures.R
\name{Normal_CI}
\alias{Normal_CI}
\title{Confidence Interval using Normal Approximation}
\usage{
Normal_CI(value, ntest, confidence = 95)
}
\arguments{
\item{value}{Performance value (a single value).}

\item{ntest}{Test set size (a single value).}

\item{confidence}{Confidence level; for instance, 95\% or 99\%. (Defaults: 95).}
}
\value{
A vector containing the CI.
}
\description{
`Normal_CI()` computes the Confidence Interval (CI) of a performance measure
(for instance, accuracy) using normal approximation. Thus, it is advisable
that the test has a size of, at least, 30 instances.
}
\examples{
# Computing accuracy
y <- c(rep("a",30),rep("b",20))
y_pred <- c(rep("a",20),rep("b",30))
ct <- table(y,y_pred)
accuracy <- Acc(ct)
# Computing 95\%CI
Normal_CI(accuracy, ntest=length(y), confidence=95)
}
