% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_effect_sizes.R
\name{compare_effect_sizes}
\alias{compare_effect_sizes}
\title{Compare effect sizes}
\usage{
compare_effect_sizes(
  effect_sizes = NULL,
  effect_size_variances = NULL,
  round_stats = TRUE,
  round_p = 3,
  round_se = 2,
  round_z = 2,
  pretty_round_p_value = TRUE
)
}
\arguments{
\item{effect_sizes}{a vector of estimated effect sizes}

\item{effect_size_variances}{a vector of variances of the effect sizes}

\item{round_stats}{logical. Should the statistics be rounded?
(default = TRUE)}

\item{round_p}{number of decimal places to which to round
p-values (default = 3)}

\item{round_se}{number of decimal places to which to round the
standard errors of the difference (default = 2)}

\item{round_z}{number of decimal places to which to round the
z-statistic (default = 2)}

\item{pretty_round_p_value}{logical. Should the p-values be rounded
in a pretty format (i.e., lower threshold: "<.001").
By default, \code{pretty_round_p_value = TRUE}.}
}
\description{
Compares effect sizes
See p. 156 of Borenstein et al. (2009, ISBN: 978-0-470-05724-7).
}
\examples{
\donttest{
compare_effect_sizes(
effect_sizes = c(0.6111, 0.3241, 0.5),
effect_size_variances = c(.0029, 0.0033, 0.01))
}
}
