% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohen_d_torchiano.R
\name{cohen_d_torchiano}
\alias{cohen_d_torchiano}
\title{Calculate Cohen's d and its confidence interval using
the package 'effsize'}
\usage{
cohen_d_torchiano(
  sample_1 = NULL,
  sample_2 = NULL,
  data = NULL,
  iv_name = NULL,
  dv_name = NULL,
  ci_range = 0.95
)
}
\arguments{
\item{sample_1}{a vector of values in the first of two samples}

\item{sample_2}{a vector of values in the second of two samples}

\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the independent variable}

\item{dv_name}{name of the dependent variable}

\item{ci_range}{range of the confidence interval for Cohen's d
(default = 0.95)}
}
\description{
To run this function, the following package(s) must be installed:
Package 'effsize' v0.8.1 (or possibly a higher version) by
Marco Torchiano (2020),
\url{https://cran.r-project.org/package=effsize}
}
\examples{
\donttest{
cohen_d_torchiano(1:10, 3:12)
cohen_d_torchiano(
data = mtcars, iv_name = "vs", dv_name = "mpg", ci_range = 0.99)
}
}
