% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_kpca3D.R
\name{plot_kpca3D}
\alias{plot_kpca3D}
\title{3D Kernel PCA Plot with Variables Representation}
\usage{
plot_kpca3D(kpca_result, target_variable = NULL, groups, scale=1, 
type = "s", size = 3/4, arrow_col = "#999999", 
angles = 12, main = NULL)
}
\arguments{
\item{kpca_result}{The result of the previously obtained kernel PCA analysis.}
\item{target_variable}{A string indicating the name of the variable to visualize as arrows on the kernel PCA plot. Default: NULL}
\item{groups}{A vector indicating the grouping of data points, if applicable. Default: NULL}
\item{scale}{Coefficient to adjust the lengths of the arrows. Default 1}
\item{type}{A character indicating the type of point for the observations.
Supported types are: 'p' for points, 's' for spheres. Default: 's'}
\item{size}{The size of the plotted points. Default: 3/4} 
\item{arrow_col}{Colour of the arrows. Default: '#999999}
\item{angles}{Number of barbs of the arrows. Default: 12}
\item{main}{Graph title. Default: NULL}
}
\value{
Provides an interactive 3D plot that displays the sample points projected onto the first three kernel principal component axes, with the variables of interest represented as arrows.
}
\description{
\code{plot_kpca3D} allows to visualize an original variable of interest in the first three principal components. The variable is displayed as an arrow, showing its relevance in the relative position of each sample point in the kernel component space.
}


\references{
Briscik, M., Dillies, MA. & Déjean, S. Improvement of variables interpretability in kernel PCA. BMC Bioinformatics 24, 282 (2023). DOI: \doi{doi:10.1186/s12859-023-05404-y}.
Variables representation as in Reverter, F., Vegas, E. & Oller, J.M. Kernel-PCA data integration with enhanced interpretability. BMC Syst Biol 8 (Suppl 2), S6 (2014). DOI: \url{doi:10.1186/1752-0509-8-S2-S6}
}

\examples{
\donttest{
library(WallomicsData)
library(kpcaIG)

Transcriptomics_Stems_s <- scale(Transcriptomics_Stems)

kpca_tan <-  kernelpca(as.matrix(Transcriptomics_Stems_s),
                          kernel = "tanhdot",
                          kpar = list(scale = 0.0001, offset = 0.01))

#Compute the most relevant genes based on the first two components of kpca_tan

kpca_ig_tan <- kpca_igrad(kpca_tan, dim = c(1,2))
head(kpca_ig_tan)


# Visualize the kpca plot.

plot_kpca3D(kpca_tan, groups = Ecotype)

#Visualize the most relevant variable (gene) according to kpca_igrad, "AT4G12060". 

plot_kpca3D(kpca_tan, "AT4G12060", groups = Ecotype, scale = 1000)

#The selected gene shows upper expression in the samples with genotype type Col.
}
}