% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-usage-tracking.R
\name{kvk_usage_alert}
\alias{kvk_usage_alert}
\title{Set usage and cost alerts for current session}
\usage{
kvk_usage_alert(max_calls = NULL, max_cost = NULL)
}
\arguments{
\item{max_calls}{Integer maximum number of paid API calls before triggering alerts,
or NULL to disable call alerts. Only basisprofiel, vestigingsprofiel, and
naamgeving calls count towards this limit. Search calls are free and do not count.
When reached, you'll see a danger alert. Continued usage beyond this limit will
show reminder warnings.}

\item{max_cost}{Numeric maximum cost in euros before triggering alerts, or NULL
to disable cost alerts. For example, 5.45 represents EUR 5.45. Costs are
calculated as EUR 0.02 per paid API call (search calls are free).}
}
\value{
No return value, called for side effects. Sets usage alert options
for the current session.
}
\description{
Configure automatic alerts to monitor your KvK API usage within the current
R session. Alerts are triggered in real-time when you exceed the specified
limits during API calls.
}
\details{
Usage alerts help you control API consumption within your current R session.
When limits are exceeded, the package displays informative messages:

\itemize{
\item \strong{First alert}: Danger alert when the limit is first reached
\item \strong{Reminder alerts}: Warning messages for continued usage over limits
}

Alert settings are stored in R options and apply only to the current session.
All alert configurations are automatically reset when you restart R.
To disable all alerts within the current session, call the function with both
parameters set to NULL: \code{kvk_usage_alert()}.

Only production API calls count towards limits. Test environment calls are ignored.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Set session limit for paid calls only (search calls don't count)
kvk_usage_alert(max_calls = 100)

# Set session cost limit to EUR 5.00
kvk_usage_alert(max_cost = 5.00)

# Set both paid call and cost limits (EUR 10.50)
kvk_usage_alert(max_calls = 500, max_cost = 10.50)

# Disable all alerts for this session
kvk_usage_alert()
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{kvk_usage_report}} for viewing current usage,
\code{\link{kvk_export_usage}} for exporting usage data,
\code{\link{kvk_reset_usage}} for clearing usage history
}
