% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maze.R
\name{maze_solve}
\alias{maze_solve}
\alias{print.maze_solve}
\alias{maze_gridsearch}
\title{Maze Solver, inspired by Micromouse competitions}
\usage{
maze_solve(
  maze,
  start = c(1, 1),
  end = dim(maze),
  inertia = FALSE,
  aim = TRUE,
  diagonal = TRUE,
  random = FALSE,
  timeout = 4,
  quiet = FALSE,
  seed = NULL,
  ...
)

\method{print}{maze_solve}(x, ...)

maze_gridsearch(
  maze,
  start = c(2, 2),
  end = round(dim(maze)/2),
  quiet = TRUE,
  seed = 123,
  ...
)
}
\arguments{
\item{maze}{Matrix. Using 0 for open space and 1 for walls.}

\item{start, end}{Integer vector, length 2. Start and end coordinates.}

\item{inertia}{Boolean. When enabled, algorithm will check for new
directions only when impossible to continue in a straight line.}

\item{aim}{Boolean. When enabled, algorithm will try first the directions
closer to the \code{end} point, ranked and sorted by shorter distances.}

\item{diagonal}{Boolean. When enabled, algorithm will have 8 degrees of
freedom to move, if not, only 4 (up, down, left, right).}

\item{random}{Boolean. When enabled, algorithm will pick next direction
randomly.}

\item{timeout}{Numeric. How many seconds set for timeout to force
algorithm to stop trying new paths?}

\item{quiet}{Boolean. Keep quiet? If not, informative messages will be shown.}

\item{seed}{Numeric. Seed to replicate random results.}

\item{...}{Additional parameters passed to \code{corr}}

\item{x}{maze_solve object}
}
\value{
List with data.frame containing solved solution, data.frame with
path coordinates and directions, steps counter and turns counter.
}
\description{
Modified recursive depth-first search (DFS) algorithm to solve mazes.
It explores the maze by recursively moving to adjacent cells until it finds a
path from the starting point to the destination. Contains options to
maximize paths by trying to turn less, allowing diagonal turns, prioritizing
turns that chooses next step pointing towards the end point, and a grid
search combining parameters to find best route.
}
\examples{
micromouse <- matrix(c(
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
  1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1,
  1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
  1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1,
  1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1,
  1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1,
  1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1,
  1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1,
  1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1,
  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
), nrow = 12, byrow = TRUE)
maze_solve(micromouse, start = c(2, 2), end = c(7, 7))
}
\seealso{
Other Games: 
\code{\link{scrabble_dictionary}()},
\code{\link{sudoku_solver}()},
\code{\link{wordle_check}()}
}
\concept{Games}
