% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/areaRegion.R
\name{areaRegion}
\alias{areaRegion}
\title{Computes area of a region}
\usage{
areaRegion(formLatticeOutput)
}
\arguments{
\item{formLatticeOutput}{An object returned by formLattice or
editLattice.}
}
\value{
Numeric The area of the bounded region.
}
\description{
This function computes the area of a region by first finding
the area of the bounding polygon, then subtracting the area
of each hole.
}
\section{Warning}{

Note that this program does not check to see if the holes are non-intersecting
or if the holes intersect the polygon.
}

\examples{
data(areaRegionExample)
attach(areaRegionExample)
hole_list <- list(hole1,hole2)
nodeFillingOutput <- nodeFilling(poly=boundary, node_spacing=0.03,
                               hole_list = hole_list)
formLatticeOutput <- formLattice(nodeFillingOutput)
plot(formLatticeOutput)
areaRegion(formLatticeOutput)
}
