% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_estimates.R
\name{parameter_estimates}
\alias{parameter_estimates}
\title{Parameter estimates from lavaan with a unified schema}
\usage{
parameter_estimates(
  fit,
  level = 0.95,
  standardized = "none",
  include_r2 = TRUE
)
}
\arguments{
\item{fit}{A fitted \code{lavaan} object.}

\item{level}{Confidence level for intervals (default \code{0.95}).}

\item{standardized}{Either a logical (FALSE/TRUE) or one of
\code{c("none", "std.all", "std.lv", "std.nox")}. If \code{TRUE}, it is treated as \code{"std.all"}.}

\item{include_r2}{Logical; include R-squared rows (only when \code{standardized = "none"}),
default \code{TRUE}.}
}
\value{
A \code{data.frame} in the style of \code{lavaan::parameterEstimates()}. If
standardized output is requested, the estimate is in column \code{est}
(renamed from \code{est.std} for consistency).
}
\description{
Extracts raw or standardized coefficients from a fitted lavaan model,
always ensuring a \code{group} column is present (set to 1 for single-group models).
Internally, the function relies on \code{lavaan::parameterEstimates()} for raw
estimates and \code{lavaan::standardizedSolution()} for standardized coefficients.
}
\details{
This wrapper harmonizes the output structure between raw and standardized
estimates, renames standardized columns to a unified schema (e.g., \code{est}
instead of \code{est.std}), and ensures that a \code{group} column is always included.
When \code{include_r2 = TRUE}, R² values are appended for each endogenous variable
if available in the model.
}
\examples{
HS.model <- ' visual  =~ x1 + x2 + x3
              textual =~ x4 + x5 + x6
              speed   =~ x7 + x8 + x9 '
fit <- lavaan::cfa(HS.model,
                   data = lavaan::HolzingerSwineford1939)

# Raw estimates with R2
pe  <- parameter_estimates(fit)

# Standardized (std.all)
pes <- parameter_estimates(fit, standardized = TRUE)

# Standardized (std.lv)
pes_lv <- parameter_estimates(fit, standardized = "std.lv")

}
