% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tilt_maps.R
\name{tilt_map}
\alias{tilt_map}
\title{Tilt raster and sf data}
\usage{
tilt_map(
  data,
  x_stretch = 2,
  y_stretch = 1.2,
  x_tilt = 0,
  y_tilt = 1,
  x_shift = 0,
  y_shift = 0,
  angle_rotate = pi/20,
  boundary = NULL,
  parallel = FALSE
)
}
\arguments{
\item{data}{sf or terra/stars/raster object.}

\item{x_stretch}{Stretch in x dimension. A \code{numeric} vector of lenght 1.}

\item{y_stretch}{Stretch in y dimension. A \code{numeric} vector of lenght 1.}

\item{x_tilt}{Tilt in x dimension. A \code{numeric} vector of lenght 1.}

\item{y_tilt}{Tilt in y dimension. A \code{numeric} vector of lenght 1.}

\item{x_shift}{Shift in x dimension. A \code{numeric} vector of lenght 1.}

\item{y_shift}{Shift in y dimension. A \code{numeric} vector of lenght 1.}

\item{angle_rotate}{Rotation angle.. A \code{numeric} vector of lenght 1. Default is \code{pi/20}.}

\item{boundary}{Another layer that is used to create a boundary that is drawn around the data}

\item{parallel}{\code{logical} to run in parallel. FALSE (default)}
}
\value{
An \code{sf} object with tilted and shifted data.
}
\description{
Tilt and shift maps in any direction.#'
}
\details{
Code adopted from https://www.mzes.uni-mannheim.de/socialsciencedatalab/article/geospatial-data/.
}
\examples{
tilt_map(landscape_1)
}
