% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/lbaModel.R
\name{dlba_inverse_external}
\alias{dlba_inverse_external}
\title{Density Function for the LBA Model Using Inverse Transform Method}
\usage{
dlba_inverse_external(
  rt_r,
  response_r,
  parameter_r,
  is_positive_drift_r,
  time_parameter_r
)
}
\arguments{
\item{rt_r}{A numeric vector of response times (RTs) for which the density
should be computed.}

\item{response_r}{An integer vector of response choices (indices of winning
accumulators), same length as \code{rt_r}.}

\item{parameter_r}{A numeric matrix of LBA parameters. Each column
corresponds to an accumulator, and each row corresponds to a parameter,
with the expected order being:
\itemize{
\item \code{A} - Starting point variability
\item \code{b} - Thresholds
\item \code{mean_v} - Mean drift rates
\item \code{sd_v} - Standard deviation drift rates
\item \code{st0} - Variability of the non-decision
\item \code{t0} - Non-decision time
}}

\item{is_positive_drift_r}{A logical vector indicating whether the drift
rate must be positive for each trial.}

\item{time_parameter_r}{A numeric vector to set the simulated time grid,
with the expected value for: minimal and maximum decision times and the
difference time (i.e., \code{min dt}, \code{max dt} and \code{dt}).}
}
\value{
A numeric vector of LBA densities, one per trial.
}
\description{
Computes the probability density of response times for the Linear
Ballistic Accumulator (LBA) model using an inverse transform formulation.
}
\details{
This function is a lower-level computational routine intended to be used
inside higher-level LBA model evaluation or fitting functions. It uses the
inverse transform method to compute exact LBA densities in a numerically
stable and efficient way. The function assumes consistent input dimensions
across all arguments.
}
