% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_toroidal_dist.R
\name{toroidal_dist_matrix_optimized}
\alias{toroidal_dist_matrix_optimized}
\title{Optimized function to compute toroidal distance matrix over a rectangular domain}
\usage{
toroidal_dist_matrix_optimized(location_matrix, x_bound, y_bound)
}
\arguments{
\item{location_matrix}{a 2 column matrix of (x,y) coordinates.}

\item{x_bound}{the upper bound for the x dimension.}

\item{y_bound}{the upper bound for the y dimension.}
}
\value{
a matrix of toroidal distances.
}
\description{
Optimized function to compute toroidal distance matrix over a rectangular domain
}
\examples{
# Generate a matrix of locations
location_matrix <- matrix(c(1, 2, 3, 4, 5, 6), ncol = 2)
x_bound <- 10
y_bound <- 10

# Compute the toroidal distance matrix
toroidal_dist_matrix_optimized(location_matrix, x_bound, y_bound)

}
\keyword{internal}
