% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_of_position.R
\name{median.leem}
\alias{median.leem}
\title{Median value}
\usage{
\method{median}{leem}(x, na.rm = FALSE, rounding = 2, grouped = TRUE, details = FALSE, ...)
}
\arguments{
\item{x}{R object (list) of class leem. Use \code{new_leem()} function.}

\item{na.rm}{a logical value indicating whether \code{NA} values should be stripped before the computation proceeds.}

\item{rounding}{Numerical object. Rounds the values in its first argument to the specified number of decimal places (default \code{2}).}

\item{grouped}{Logical object. Determines whether the measure of position result will be based on grouped data or not (default \code{TRUE}).}

\item{details}{Logical object. Details of data (default \code{FALSE}).}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Class method leem for the generic median function
}
\examples{
library(leem)
library(stats)
# Examples
rnorm(36, 100, 50) |> new_leem(variable = 2) |> tabfreq() |> median()
}
