% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_of_position.R
\name{mpos}
\alias{mpos}
\title{Measures of position}
\usage{
mpos(
  x,
  trim = 0,
  na.rm = FALSE,
  rounding = 2,
  grouped = TRUE,
  details = FALSE,
  ...
)
}
\arguments{
\item{x}{R object (list) of class leem. Use \code{new_leem()} function. Complex vectors are allowed for \code{trim = 0}, only.}

\item{trim}{The fraction (0 to 0.5) of observations to be trimmed from each end of x before the mean is computed. Values of trim outside that range are taken as the nearest endpoint.}

\item{na.rm}{a logical value indicating whether \code{NA} values should be stripped before the computation proceeds.}

\item{rounding}{Numerical object. Rounds the values in its first argument to the specified number of decimal places (default \code{2}).}

\item{grouped}{Logical object. Determines whether the measure of position result will be based on grouped data or not (default \code{TRUE}).}

\item{details}{Logical object. Details of data (default \code{FALSE}).}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Compute all measures of position
}
\details{
The measures of position are: average, median and mode.
}
\examples{
# Example 1: Poisson data
rpois(30, 2.5) |>
  new_leem() |>
  mpos()
# Example 2: Normal data
rnorm(50, 100, 2.5) |>
  new_leem(variable = 2) |>
  mpos(grouped = FALSE)
}
