% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{find_partition_rcpp}
\alias{find_partition_rcpp}
\title{Refer to the R function find_partition()
For notes of the graph object, refer to https://igraph.org/c/doc/igraph-Basic.html}
\usage{
find_partition_rcpp(
  edgelist,
  edgelist_length,
  num_vertices,
  direction,
  edge_weights,
  resolution = 1,
  niter = 2L
)
}
\arguments{
\item{edgelist}{The graph edge list}

\item{edgelist_length}{integer The length of the graph edge list}

\item{num_vertices}{integer The number of vertices in the graph}

\item{direction}{boolean Whether the graph is directed or undirected}

\item{edge_weights}{Vector of edge weights. In weighted graphs, a real number is assigned to each (directed or undirected) edge. For an unweighted graph, this is set to 1. Refer to igraph, weighted graphs.}

\item{resolution}{Numeric scalar, resoluiton parameter controlling communities detected (default=1.0) Higher resolutions lead to more communities, while lower resolutions lead to fewer communities.}

\item{niter}{Number of iterations that the algorithm should be run for (default=2)}
}
\value{
A vector of membership values
}
\description{
Refer to the R function find_partition()
For notes of the graph object, refer to https://igraph.org/c/doc/igraph-Basic.html
}
\examples{
library(igraph)
edgelist <- as.vector(t(igraph::as_edgelist(exampleGraph, names=FALSE))) - 1
edgelist_length <- length(edgelist)
num_vertices <- length(igraph::V(exampleGraph)) - 1
direction <- igraph::is_weighted(exampleGraph)
find_partition_rcpp(edgelist, edgelist_length, num_vertices, direction, E(exampleGraph)$weight)
}
