test_that("triangular", {
    expect_equal(triangular(0, 1, 2)(-5), 0)
    expect_equal(triangular(0, 1, 2)(-1), 0)
    expect_equal(triangular(0, 1, 2)(0), 0)
    expect_equal(triangular(0, 1, 2)(0.5), 0.5)
    expect_equal(triangular(0, 1, 2)(1), 1)
    expect_equal(triangular(0, 1, 2)(1.5), 0.5)
    expect_equal(triangular(0, 1, 2)(2), 0)
    expect_equal(triangular(0, 1, 2)(10), 0)
    expect_equal(triangular(0, 1, 2)(-Inf), 0)
    expect_equal(triangular(0, 1, 2)(Inf), 0)

    expect_equal(triangular(1, 1, 2)(-1), 0)
    expect_equal(triangular(1, 1, 2)(0), 0)
    expect_equal(triangular(1, 1, 2)(1), 1)
    expect_equal(triangular(1, 1, 2)(1.5), 0.5)
    expect_equal(triangular(1, 1, 2)(2), 0)
    expect_equal(triangular(1, 1, 2)(10), 0)
    expect_equal(triangular(1, 1, 2)(-Inf), 0)
    expect_equal(triangular(1, 1, 2)(Inf), 0)

    expect_equal(triangular(0, 1, 1)(-1), 0)
    expect_equal(triangular(0, 1, 1)(0), 0)
    expect_equal(triangular(0, 1, 1)(0.5), 0.5)
    expect_equal(triangular(0, 1, 1)(1), 1)
    expect_equal(triangular(0, 1, 1)(2), 0)
    expect_equal(triangular(0, 1, 1)(10), 0)
    expect_equal(triangular(0, 1, 1)(-Inf), 0)
    expect_equal(triangular(0, 1, 1)(Inf), 0)

    expect_equal(triangular(1, 1, 1)(0), 0)
    expect_equal(triangular(1, 1, 1)(1), 1)
    expect_equal(triangular(1, 1, 1)(2), 0)
    expect_equal(triangular(1, 1, 1)(-Inf), 0)
    expect_equal(triangular(1, 1, 1)(Inf), 0)

    expect_equal(triangular(-Inf, 1, 2)(-5), 1)
    expect_equal(triangular(-Inf, 1, 2)(0), 1)
    expect_equal(triangular(-Inf, 1, 2)(1), 1)
    expect_equal(triangular(-Inf, 1, 2)(1.5), 0.5)
    expect_equal(triangular(-Inf, 1, 2)(2), 0)
    expect_equal(triangular(-Inf, 1, 2)(5), 0)
    expect_equal(triangular(-Inf, 1, 2)(-Inf), 1)
    expect_equal(triangular(-Inf, 1, 2)(Inf), 0)

    expect_equal(triangular(0, 1, Inf)(0), 0)
    expect_equal(triangular(0, 1, Inf)(0.5), 0.5)
    expect_equal(triangular(0, 1, Inf)(1), 1)
    expect_equal(triangular(0, 1, Inf)(2), 1)
    expect_equal(triangular(0, 1, Inf)(5), 1)
    expect_equal(triangular(0, 1, Inf)(-Inf), 0)
    expect_equal(triangular(0, 1, Inf)(Inf), 1)

    expect_equal(triangular(-Inf, 1, Inf)(-5), 1)
    expect_equal(triangular(-Inf, 1, Inf)(0), 1)
    expect_equal(triangular(-Inf, 1, Inf)(1), 1)
    expect_equal(triangular(-Inf, 1, Inf)(2), 1)
    expect_equal(triangular(-Inf, 1, Inf)(5), 1)
    expect_equal(triangular(-Inf, 1, Inf)(-Inf), 1)
    expect_equal(triangular(-Inf, 1, Inf)(Inf), 1)

    expect_equal(triangular(-Inf, -Inf, Inf)(1), 1)
    expect_equal(triangular(-Inf, Inf, Inf)(1), 1)
    expect_equal(triangular(-Inf, Inf, Inf)(-Inf), 1)
    expect_equal(triangular(-Inf, Inf, Inf)(Inf), 1)

    expect_equal(triangular(0, 1, 2)(NA), as.numeric(NA))
    expect_equal(triangular(0, 1, 2)(NaN), as.numeric(NaN))
})


test_that("raisedcosine", {
    expect_equal(raisedcosine(0, 1, 2)(-5), 0)
    expect_equal(raisedcosine(0, 1, 2)(-1), 0)
    expect_equal(raisedcosine(0, 1, 2)(0), 0)
    expect_equal(raisedcosine(0, 1, 2)(0.5), 0.5)
    expect_equal(raisedcosine(0, 1, 2)(1), 1)
    expect_equal(raisedcosine(0, 1, 2)(1.5), 0.5)
    expect_equal(raisedcosine(0, 1, 2)(2), 0)
    expect_equal(raisedcosine(0, 1, 2)(10), 0)
    expect_equal(raisedcosine(0, 1, 2)(-Inf), 0)
    expect_equal(raisedcosine(0, 1, 2)(Inf), 0)

    expect_equal(raisedcosine(1, 1, 2)(-1), 0)
    expect_equal(raisedcosine(1, 1, 2)(0), 0)
    expect_equal(raisedcosine(1, 1, 2)(1), 1)
    expect_equal(raisedcosine(1, 1, 2)(1.5), 0.5)
    expect_equal(raisedcosine(1, 1, 2)(2), 0)
    expect_equal(raisedcosine(1, 1, 2)(10), 0)
    expect_equal(raisedcosine(1, 1, 2)(-Inf), 0)
    expect_equal(raisedcosine(1, 1, 2)(Inf), 0)

    expect_equal(raisedcosine(0, 1, 1)(-1), 0)
    expect_equal(raisedcosine(0, 1, 1)(0), 0)
    expect_equal(raisedcosine(0, 1, 1)(0.5), 0.5)
    expect_equal(raisedcosine(0, 1, 1)(1), 1)
    expect_equal(raisedcosine(0, 1, 1)(2), 0)
    expect_equal(raisedcosine(0, 1, 1)(10), 0)
    expect_equal(raisedcosine(0, 1, 1)(-Inf), 0)
    expect_equal(raisedcosine(0, 1, 1)(Inf), 0)

    expect_equal(raisedcosine(1, 1, 1)(0), 0)
    expect_equal(raisedcosine(1, 1, 1)(1), 1)
    expect_equal(raisedcosine(1, 1, 1)(2), 0)
    expect_equal(raisedcosine(1, 1, 1)(-Inf), 0)
    expect_equal(raisedcosine(1, 1, 1)(Inf), 0)

    expect_equal(raisedcosine(-Inf, 1, 2)(-5), 1)
    expect_equal(raisedcosine(-Inf, 1, 2)(0), 1)
    expect_equal(raisedcosine(-Inf, 1, 2)(1), 1)
    expect_equal(raisedcosine(-Inf, 1, 2)(1.5), 0.5)
    expect_equal(raisedcosine(-Inf, 1, 2)(2), 0)
    expect_equal(raisedcosine(-Inf, 1, 2)(5), 0)
    expect_equal(raisedcosine(-Inf, 1, 2)(-Inf), 1)
    expect_equal(raisedcosine(-Inf, 1, 2)(Inf), 0)

    expect_equal(raisedcosine(0, 1, Inf)(0), 0)
    expect_equal(raisedcosine(0, 1, Inf)(0.5), 0.5)
    expect_equal(raisedcosine(0, 1, Inf)(1), 1)
    expect_equal(raisedcosine(0, 1, Inf)(2), 1)
    expect_equal(raisedcosine(0, 1, Inf)(5), 1)
    expect_equal(raisedcosine(0, 1, Inf)(-Inf), 0)
    expect_equal(raisedcosine(0, 1, Inf)(Inf), 1)

    expect_equal(raisedcosine(-Inf, 1, Inf)(-5), 1)
    expect_equal(raisedcosine(-Inf, 1, Inf)(0), 1)
    expect_equal(raisedcosine(-Inf, 1, Inf)(1), 1)
    expect_equal(raisedcosine(-Inf, 1, Inf)(2), 1)
    expect_equal(raisedcosine(-Inf, 1, Inf)(5), 1)
    expect_equal(raisedcosine(-Inf, 1, Inf)(Inf), 1)
    expect_equal(raisedcosine(-Inf, 1, Inf)(-Inf), 1)

    expect_equal(raisedcosine(-Inf, -Inf, Inf)(1), 1)
    expect_equal(raisedcosine(-Inf, Inf, Inf)(1), 1)
    expect_equal(raisedcosine(-Inf, Inf, Inf)(Inf), 1)
    expect_equal(raisedcosine(-Inf, Inf, Inf)(-Inf), 1)

    expect_equal(raisedcosine(0, 1, 2)(NA), as.numeric(NA))
    expect_equal(raisedcosine(0, 1, 2)(NaN), as.numeric(NaN))
})
