% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Appender.R
\name{AppenderTable}
\alias{AppenderTable}
\title{Abstract class for logging to tabular structures}
\description{
\strong{NOTE}: This is an \emph{abstract class}. Abstract classes cannot be instantiated
directly, but are exported for package developers that want to extend lgr -
for example by creating their own \link[=Appender]{Appenders} or \link[=Layout]{Layouts}.
Please refer to the \emph{see also} section for actual implementations of this
class.

AppenderTable is extended by Appenders that write to a data
source that can be interpreted as tables, (usually a \code{data.frame}). Examples
are \code{AppenderDbi}, \code{AppenderRjdbc} and \code{AppenderDt} from the
\href{https://github.com/s-fleck/lgrExtra}{lgrExtra} package.
}
\seealso{
Other abstract classes: 
\code{\link{Appender}},
\code{\link{AppenderMemory}},
\code{\link{Filterable}}

Other Appenders: 
\code{\link{Appender}},
\code{\link{AppenderBuffer}},
\code{\link{AppenderConsole}},
\code{\link{AppenderFile}},
\code{\link{AppenderFileRotating}},
\code{\link{AppenderFileRotatingDate}},
\code{\link{AppenderFileRotatingTime}}
}
\concept{Appenders}
\concept{abstract classes}
\section{Super classes}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{\link[lgr:Appender]{lgr::Appender}} -> \code{AppenderTable}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{data}}{\code{character} scalar. Contents of the table, parsed to a
\code{data.frame}.}

\item{\code{data}}{\code{character} scalar. Like \verb{$data}, but returns a \code{data.table}
instead (requires the \strong{data.table} package).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AppenderTable-new}{\code{AppenderTable$new()}}
\item \href{#method-AppenderTable-show}{\code{AppenderTable$show()}}
\item \href{#method-AppenderTable-format}{\code{AppenderTable$format()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-add_filter'><code>lgr::Filterable$add_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter"><a href='../../lgr/html/Filterable.html#method-Filterable-filter'><code>lgr::Filterable$filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-remove_filter'><code>lgr::Filterable$remove_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters"><a href='../../lgr/html/Filterable.html#method-Filterable-set_filters'><code>lgr::Filterable$set_filters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="append"><a href='../../lgr/html/Appender.html#method-Appender-append'><code>lgr::Appender$append()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_layout"><a href='../../lgr/html/Appender.html#method-Appender-set_layout'><code>lgr::Appender$set_layout()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_threshold"><a href='../../lgr/html/Appender.html#method-Appender-set_threshold'><code>lgr::Appender$set_threshold()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderTable-new"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderTable-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderTable$new(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderTable-show"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderTable-show}{}}}
\subsection{Method \code{show()}}{
Show recent log entries
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderTable$show(threshold = NA_integer_, n = 20L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{threshold}}{an \code{integer} or \code{character} \link[=log_level]{threshold}.
Only show events with a log level at or below this threshold.}

\item{\code{n}}{a positive \code{integer} scalar. Show at most that many entries}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderTable-format"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderTable-format}{}}}
\subsection{Method \code{format()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderTable$format(color = FALSE, ...)}\if{html}{\out{</div>}}
}

}
}
