% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_tocsv.R
\name{lr_convert_tocsv}
\alias{lr_convert_tocsv}
\title{Convert spectral data files to csv files}
\usage{
lr_convert_tocsv(
  where = NULL,
  ext = "txt",
  subdir = FALSE,
  ignore.case = TRUE,
  overwrite = FALSE,
  metadata = TRUE,
  ...
)
}
\arguments{
\item{where}{Folder in which files are located (defaults to current working
directory).}

\item{ext}{File extension to be searched for, without the "." (defaults to
\code{txt}). You can also use a character vector to specify multiple file
extensions.}

\item{subdir}{Should subdirectories within the \code{where} folder be included in
the search? (defaults to \code{FALSE}).}

\item{ignore.case}{Should the extension search be case insensitive? (defaults
to \code{TRUE})}

\item{overwrite}{logical. Should the function overwrite existing files with
the same name? (defaults to \code{FALSE}).}

\item{metadata}{logical (defaults to \code{TRUE}). Should metadata be exported as
well? They will be exported in csv files will the \verb{_metadata.csv} suffix.}

\item{...}{Arguments passed to individual parsers.}
}
\value{
Convert input files to csv and invisibly return the list of created
file paths
}
\description{
Convert spectral data files to csv files
}
\details{
You can customise the type of parallel processing used by this function with
the \code{\link[future:plan]{future::plan()}} function. This works on all operating systems, as well
as high performance computing (HPC) environment. Similarly, you can customise
the way progress is shown with the \code{\link[progressr:handlers]{progressr::handlers()}} functions
(progress bar, acoustic feedback, nothing, etc.)
}
\section{Warning}{


When \code{metadata = TRUE}, if \strong{either} the data \strong{or} metadata export fails,
nothing will be returned for this file.
}

