% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_plot_observed.R
\name{mle_plot_observed}
\alias{mle_plot_observed}
\title{Plots Observed vs. Predicted MLE}
\usage{
mle_plot_observed(
  x,
  yvar,
  annotate = TRUE,
  lab_x = "Observed",
  lab_y = "Predicted",
  ...
)
}
\arguments{
\item{x}{List with the results of the simulated annealing algorithm for Maximum
Likelihood Estimation. See \code{\link[likelihood:anneal]{likelihood::anneal()}}}

\item{yvar}{The name of the column that contains the dependent variable
(the “observed” value). This column must be present in the \code{source_data}
of the \code{x} (results) list}

\item{annotate}{logical (default to TRUE), display the values of \eqn{R^2}
and slope of the regression of the observed on predicted values. See
\code{\link[likelihood:simulated_annealing_algorithm]{likelihood::Simulated Annealing Algorithm}}}

\item{lab_x}{The text for the x-axis lab}

\item{lab_y}{The text for the y-axis lab}

\item{...}{other ggplot2 parameters}
}
\value{
A \code{ggplot} object displaying the observed vs. predicted values,
with optional annotations for \eqn{R^2} and regression slope.
}
\description{
Plots observed values \emph{vs.} predicted values. The predicted values are obtained
from the model with the parameters values estimated by maximum likelihood
estimation using simulated annealing.
}
