% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likert.options.R
\name{likert.options}
\alias{likert.options}
\title{Builds an object with options for plotting \code{\link{likert}} results.}
\usage{
likert.options(
  low.color = "#D8B365",
  high.color = "#5AB4AC",
  neutral.color = "grey90",
  neutral.color.ramp = "white",
  colors = NULL,
  plot.percent.low = TRUE,
  plot.percent.high = TRUE,
  plot.percent.neutral = TRUE,
  plot.percents = FALSE,
  text.size = 3,
  text.color = "black",
  centered = TRUE,
  include.center = TRUE,
  ordered = TRUE,
  wrap = 50,
  wrap.grouping = 50,
  legend = "Response",
  legend.position = "bottom",
  panel.arrange = "v",
  panel.strip.color = "#F0F0F0",
  ...
)
}
\arguments{
\item{low.color}{color for low values.}

\item{high.color}{color for high values.}

\item{neutral.color}{color for middle values (if odd number of levels).}

\item{neutral.color.ramp}{second color used when calling \code{\link{colorRamp}}
with \code{low.color} and \code{high.color} to define the color palettes.}

\item{colors}{vector specifying the colors to use. This must be equal to 
the number of likert levels.}

\item{plot.percent.low}{whether to plot low percentages.}

\item{plot.percent.high}{whether to plot high percentages.}

\item{plot.percent.neutral}{whether to plot netural percentages.}

\item{plot.percents}{whether to label each category/bar.}

\item{text.size}{size of text attributes.}

\item{text.color}{color of text attributes.}

\item{centered}{if true, the bar plot will be centered around zero such that
the lower half of levels will be negative.}

\item{include.center}{if TRUE, include the center level in the plot otherwise
the center will be excluded.}

\item{ordered}{reorder items from high to low.}

\item{wrap}{width to wrap label text for item labels}

\item{wrap.grouping}{width to wrap label text for group labels.}

\item{legend}{title for the legend.}

\item{legend.position}{the position for the legend ("left", "right", "bottom",
"top", or two-element numeric vector).}

\item{panel.arrange}{how panels for grouped likert items should be arrange.
Possible values are \code{v} (vertical, the default), \code{h}
(horizontal), and \code{NULL} (auto fill horizontal and vertical)}

\item{panel.strip.color}{the background color for panel labels.}

\item{...}{included for future expansion.}
}
\description{
Builds an object with options for plotting \code{\link{likert}} results.
}
