% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{centerItem}
\alias{centerItem}
\title{Move the window such that given item or items are centered}
\usage{
centerItem(id, itemId, options)
}
\arguments{
\item{id}{graph2d id or a \code{linevis} object (the output from \code{linevis()})}

\item{itemId}{A vector (or single value) of the item ids to center}

\item{options}{Named list of options controlling mainly the animation.
Most common option is \code{"animation" = TRUE/FALSE}. For a full list of
options, see the "focus" method in the
\href{https://visjs.github.io/vis-timeline/docs/graph2d/#Methods}{official
graph2d documentation}}
}
\value{
None, side-effect is Javascript call
}
\description{
Move the window such that given item or items are centered
}
\examples{
\dontrun{
linevis(data.frame(
          start = c(Sys.Date() - 1, Sys.Date(), Sys.Date() + 1),
          content = c("Item 1", "Item 2", "Item 3"))
) \%>\%
  centerItem(1)
}

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    linevisOutput("graph2d"),
    actionButton("btn", "Center around item 1")
  ),
  server = function(input, output) {
    output$graph2d <- renderLinevis(
      linevis(
        data.frame(
          start = c(Sys.Date() - 1, Sys.Date(), Sys.Date() + 1),
          content = c("Item 1", "Item 2", "Item 3"))
      )
    )
    observeEvent(input$btn, {
      centerItem("graph2d", 1)
    })
  }
)
}
}
