
  df_data = data.frame(x = c(
                             '2014-06-11',
                             '2014-06-12',
                             '2014-06-13',
                             '2014-06-14',
                             '2014-06-15',
                             '2014-06-16',
                             '2014-06-09',
                             '2014-06-18'),
                      y = c(
                            0,
                            1,
                            30000,
                            10,
                            150,
                            30000,
                            20,
                            20),
                      group = c(rep(0, 6), 1, 1))

  df_grp = data.frame(id = 0:1, content = c('ESR', 'threshold'),
                      className = c('grp1', 'grp2'))

test_that("linevis groups", {

  linevis_obj = linevis(df_data)
  expect_true(TRUE)
})

test_that("linevis options", {


  min_range = '2014-06-11'
  max_range = '2014-06-18'


  legend_pos = list(left = list(position = 'bottom-left'))

  linevis_log_obj = linevis(df_data, groups = df_grp, log_scale = TRUE,
                            options = list(min = min_range, max = max_range,
                                           interpolation = FALSE,
                                           legend = legend_pos))

  expect_true(TRUE)
})
