#' @title Austrian Vacation Activities Dataset
#' @details
#' The Austrian Vacation Activities dataset comprises responses from 2,961 adult
#' tourists who spent their holiday in Austria during the 1997/98 season. The
#' responses are coded in binary with 0 indicating that the tourist didn't
#' partake in the activity and 1 indicating they did.
#' @name winterActiv
#' @docType data
#' @format A 2961 x 27 array of binary responses
#' @keywords datasets
#' @source https://statistik.boku.ac.at/nachlass_leisch/MSA/
#' @examples
#' data(winterActiv)
#' head(winterActiv)
"winterActiv"

#' @title Australian Vacation Activities Dataset
#' @details
#' The Australian Vacation Activities dataset includes responses from 1,003
#' adult Australians who were surveyed on their vacation activities
#' through a permission-based internet panel in 2007.The responses are coded in
#' binary with 0 indicating that the tourist didn't partake in the activity and
#' 1 indicating they did.
#' @name ausActiv
#' @docType data
#' @format A 1003 x 44 array of binary responses
#' @keywords datasets
#' @source https://statistik.boku.ac.at/nachlass_leisch/MSA/
#' @examples
#' data(ausActiv)
#' head(ausActiv)
"ausActiv"

#' @title Chemical Manufacturing Process Dataset
#' @details
#' This data set contains information about a chemical manufacturing process, in
#' which the goal is to understand the relationship between the process and the
#' resulting final product yield and can be found in the in the
#' AppliedPredictiveModeling R package. The data has been copied from
#' http://appliedpredictivemodeling.com/data in agreement with their license.
#' @name ChemicalManufacturingProcess
#' @docType data
#' @format A 176 x 58 array of continuous variables
#' @keywords datasets
#' @source http://appliedpredictivemodeling.com/data
#' @examples
#' data(ChemicalManufacturingProcess)
#' head(ChemicalManufacturingProcess)
"ChemicalManufacturingProcess"

#' @title Risk Dataset
#' @details
#' Adult Australian residents that have undertaken at least one holiday in the
#' last year, which involved staying away from home for at least four nights,
#' were asked what risks they have taken in the past. The questions were about
#' recreational, health, career, financial, safety and social risk. The response
#' options were on the following: never (1), rarely (2), quite often (3),
#' often (4) or very often (5)
#' @name risk
#' @docType data
#' @format A 563 x 6 array of Likert scale data
#' @keywords datasets
#' @source https://statistik.boku.ac.at/nachlass_leisch/MSA/
#' @examples
#' data(risk)
#' head(risk)
"risk"
