% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcd2.R
\name{mcd2}
\alias{mcd2}
\title{Multinomial Canonical Decomposition Model for a multinomial outcome}
\usage{
mcd2(X, G, Z, S = 2, trace = TRUE, maxiter = 65536, dcrit = 1e-06)
}
\arguments{
\item{X}{An N by P matrix with predictor variables}

\item{G}{An N times C class indicator matrix}

\item{Z}{design matrix for response}

\item{S}{Positive number indicating the dimensionality of teh solution}

\item{trace}{whether progress information should be printed on the screen}

\item{maxiter}{maximum number of iterations}

\item{dcrit}{convergence criterion}
}
\value{
This function returns an object of the class \code{mcd} with components:
\item{call}{function call}
\item{Xoriginal}{Matrix X from input}
\item{G}{Class indicator matrix G}
\item{X}{Scaled X matrix}
\item{mx}{Mean values of X}
\item{sdx}{Standard deviations of X}
\item{pnames}{Variable names of profiles}
\item{xnames}{Variable names of predictors}
\item{znames}{Variable names of responses}
\item{Z}{Design matrix Z}
\item{m}{main effects}
\item{Bx}{regression weights for X}
\item{Bz}{regression weights for Z}
\item{A}{regression weights (Bx Bz')}
\item{U}{matrix with coordinates for row-objects}
\item{V}{matrix with coordinates for column-objects}
\item{Ghat}{Estimated values of G}
\item{deviance}{value of the deviance at convergence}
\item{df}{number of paramters}
\item{AIC}{Akaike's informatoin criterion}
\item{iter}{number of main iterations from the MM algorithm}
\item{svd}{Singular value decomposition in last iteration}
}
\description{
The function mcd2 fits the multinomial canonical decomposition model to a multinomial outcome
i.e. a double constrained reduced rank multinomial logistic model
}
\examples{
\dontrun{
data(dataExample_lpca)
Y = as.matrix(dataExample_lpca[ , 1:5])
X = as.matrix(dataExample_lpca[ , 9:13])
#unsupervised
output = mcd1(X, Y, S = 2, ord.z = 2)
}

}
