% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector-text.R
\name{vector_text_coords}
\alias{vector_text_coords}
\title{Create data.frame of glyph information for the given text.}
\usage{
vector_text_coords(
  text,
  font = c("gridfont_smooth", "gridfont", "arcade"),
  dx = 0L,
  dy = 0L,
  missing = utf8ToInt("?")
)
}
\arguments{
\item{text}{Single text string. Can include carriage returns to split text 
over multiple lines.}

\item{font}{Name of vector font, or a vector 'lofi' font object.  Default: 'gridfont_smooth'.
Use \code{get_lofi_names('vector')} to retrieve a list of all valid
vector fonts included in this package.}

\item{dx}{Additional character spacing in the horizontal direction. Default: 0}

\item{dy}{Additional character spacing in the vertical direction i.e. between 
rows of text. Default: 0}

\item{missing}{Codepoint to use if glyph not found in font. 
Default: NULL means to use the default specified by the font internally.
Otherwise it will default to the codepoint for '?'}
}
\value{
data.frame of stroke information
\describe{
  \item{\code{char_idx}}{The index of the character within the provided \code{text} string}
  \item{\code{codepoint}}{Unicode codepoint (integer)}
  \item{\code{stroke_idx}}{Index of the stroke within each character}
  \item{\code{x}}{Pixel coordinate x value for display}
  \item{\code{y}}{Pixel coordinate y value for display}
  \item{\code{line}}{Line number within input \code{text} where this character appears}
  \item{\code{x0}}{Original untransformed x-coordinate}
  \item{\code{y0}}{Original untransformed y-coordinate}
}
}
\description{
Text input can contain multiple lines separated by carriage returns
}
\examples{
vector_text_coords('Hi')
}
\seealso{
Other vector text functions: 
\code{\link{vector_text_matrix}()},
\code{\link{vector_text_raster}()}
}
\concept{vector text functions}
