% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers.R
\name{warning}
\alias{warning}
\title{Warning Log Handler}
\usage{
warning(
  ...,
  call. = TRUE,
  immediate. = FALSE,
  noBreaks. = FALSE,
  domain = NULL,
  .loggit = NA,
  echo = get_echo()
)
}
\arguments{
\item{...}{zero or more objects which can be coerced to character
    (and which are pasted together with no separator) or a single
    condition object.}

\item{call.}{logical, indicating if the call should become part of the
    warning message.}

\item{immediate.}{logical, indicating if the call should be output
    immediately, even if \code{\link[base]{getOption}("warn") <= 0}.}

\item{noBreaks.}{logical, indicating as far as possible the message should
    be output as a single line when \code{options(warn = 1)}.}

\item{domain}{see \code{\link[base]{gettext}}.  If \code{NA}, messages will
    not be translated, see also the note in \code{\link[base]{stop}}.}

\item{.loggit}{Should the condition message be added to the log?
If \code{NA} the log level set by \code{set_log_level()} is used to determine if the condition should be logged.}

\item{echo}{Should the log entry (json) be echoed to \code{stdout} as well?}
}
\value{
The warning message as \code{\link[base]{character}} string, invisibly.
}
\description{
This function is identical to base R's \code{\link[base:warning]{warning}},
but it includes logging of the exception message via \code{loggit()}.
}
\examples{
\dontrun{
  warning("You may want to review that math")

  warning("You may want to review that math", immediate = FALSE, echo = FALSE)
}

}
\seealso{
Other handlers: 
\code{\link{debuginfo}()},
\code{\link{message}()},
\code{\link{stop}()},
\code{\link{stopifnot}()}
}
\concept{handlers}
