% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logr.R
\name{log_info}
\alias{log_info}
\title{Logs an informational message}
\usage{
log_info(msg, console = TRUE, blank_after = NULL, hide_notes = FALSE)
}
\arguments{
\item{msg}{The message to log.  The message must be a character string.}

\item{console}{Whether or not to print to the console.  Valid values are
TRUE and FALSE.  Default is TRUE.}

\item{blank_after}{Whether or not to print a blank line following the
printed message.  The blank line helps readability of the log.  Valid values
are TRUE and FALSE. Default is TRUE.}

\item{hide_notes}{If notes are on, this parameter gives you the option
of not printing notes for a particular log entry.  Default is FALSE,
meaning notes will be displayed.  Used internally.}
}
\value{
The object, invisibly
}
\description{
Writes an informational message to the log. Message will be written
to the log at the point the function is called.
}
\examples{
library(logr)

# Create temp file location
tmp <- file.path(tempdir(), "test.log")

# Open log
lf <- log_open(tmp)

# Send info to log
log_info("Here is an info message")

# Close log
log_close()

# View results
writeLines(readLines(lf))

}
\seealso{
\code{\link{log_warning}} to write a warning message to the log.
}
