% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gofit.R
\name{plot.gofit}
\alias{plot.gofit}
\title{Plots a gofit object}
\usage{
\method{plot}{gofit}(
  x,
  y,
  type = c("line", "box"),
  scaling = c("none", "std", "sqrt"),
  lineAlpha = 0.06,
  lineSize = 1,
  ...
)
}
\arguments{
\item{x}{the gofit object}

\item{y}{unused}

\item{type}{type of plot, boxplot or lineplot}

\item{scaling}{type of scaling of the network statistics. If "std", network statistics are scaling by subtracting off the observed statistics and scaling by the standard deviation. If "sqrt", network statistics are plotted on the square root scale (The square root is the variance stabilizing transformation for a Poisson random variable). The default is "none", where by the network statistics are not scaled.}

\item{lineAlpha}{The transparency of the simulated statistics lines}

\item{lineSize}{The width of the lines}

\item{...}{passed to either boxplot or geom_line}
}
\description{
Plots a gofit object
}
\examples{
library(network)
data(ukFaculty)

# Delete vertices missing group
delete.vertices(ukFaculty, which(is.na(ukFaculty \%v\% "Group")))

# A dyad independent model
fitind <- lolog(ukFaculty ~ edges() + nodeMatch("GroupC") + nodeCov("GroupC"))
summary(fitind)

# Check gof on degree distribution (bad!)
gind <- gofit(fitind, ukFaculty ~ degree(0:50))
plot(gind)
plot(gind, type="box")
}
