% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netcdf_parse.R
\name{netcdf_to_df}
\alias{netcdf_to_df}
\title{Read Station-based evd NetCDF File into a Data Frame}
\usage{
netcdf_to_df(netcdf_file, exclude_cov = FALSE)
}
\arguments{
\item{netcdf_file}{The path to the NetCDF file.}

\item{exclude_cov}{Logical, if TRUE, variables starting with 'cov' will be excluded. Default is FALSE.}
}
\value{
A data frame containing the data from the NetCDF file.
}
\description{
This function reads a NetCDF file with EVD parameters (e.g. loc and scale) with a station dimension and converts it
back into a data frame. The function assumes that the NetCDF file has a
'station' dimension with associated variables such as latitude, longitude,
and other station-specific data.
}
\examples{
tf = tempfile("test.nc")
# Ten records of 20 random data generated from the fgumbel EVD
am = lapply(1:10, function(x) evd::rgumbel(20))
tab = as.data.frame(t(sapply(am,function(x) evd_params(x,"fgumbel"))))
tab$lon = rnorm(10,sd=10) #station latitude
tab$lat = rnorm(10,sd=20) #station longitude
loopevd::df_to_netcdf(df = tab,output_file = tf)
tab2 = loopevd::netcdf_to_df(tf)

}
