% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/municipalities.R
\docType{data}
\name{Horomerice_PZ_cz}
\alias{Horomerice_PZ_cz}
\title{Municipal Election Data: Horomerice (PZ, CZ)}
\format{
An object of class \code{data.frame} with 438 rows and 14 columns.
}
\source{
The dataset was compiled primarily from official election results published by
the Czech Statistical Office. Additional contextual or verification information
(such as post-election roles) was obtained from publicly available municipal
records.
\itemize{
\item \href{https://www.volby.cz/index_en.htm}{Czech Statistical Office}
\item \href{https://www.horomerice.cz/}{Municipality website}
\item Kadlecova, S. (2013). \emph{Lokalni stranicky system v obci Horomerice}
(Local Party System in the Municipality of Horomerice).
Bachelor thesis. Czech University of Life Sciences Prague.
[\href{https://theses.cz/id/9eylkt/?lang=en}{Full text}]
\item Bares, M. (2009). \emph{Spolecensky a politicky zivot v obci Horomerice}
(The Public Life and the Political Process in Horomerice).
Bachelor thesis. Czech University of Life Sciences Prague.
[\href{https://theses.cz/id/8bgzon/?lang=en}{Full text}]
}
}
\usage{
Horomerice_PZ_cz
}
\description{
A dataset containing individual-level candidacy records from municipal
elections in the municipality of Horomerice (district Praha-zapad, Czech
Republic).
}
\details{
\tabular{ll}{
   \strong{Dataset overview:} \tab  \cr
   Municipality: \tab Horomerice \cr
   District: \tab Praha-zapad \cr
   Country: \tab Czech Republic \cr
   Number of elections: \tab 8 \cr
   Elections covered: \tab 1994, 1998, 2002, 2006, 2010, 2014, 2018, 2022 \cr
   Number of candidacies (rows): \tab 438 \cr
   Note: \tab \href{https://www.horomerice.cz/}{Municipality website} \cr
}
}
\section{Description of variables}{
\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   elections \tab Election identifiers (numeric) \cr
   candidate \tab Candidate's full name (character) \cr
   list_name \tab Name of the candidate list (character) \cr
   list_pos \tab Candidate's position on the list (numeric) \cr
   pref_votes \tab Number of preferential votes (numeric) \cr
   elected \tab Logical; TRUE if candidate was elected \cr
   nom_party \tab Nominating party (character) \cr
   pol_affil \tab Political affiliation (character) \cr
   mayor \tab TRUE if elected mayor \cr
   dep_mayor \tab TRUE if elected deputy mayor \cr
   board \tab TRUE if member of the executive board \cr
   gov_support \tab TRUE if supported the local government \cr
   elig_voters \tab Number of eligible voters (numeric) \cr
   ballots_cast \tab Number of ballots cast (numeric) \cr
}


Each record describes one candidate's run for office, including their candidate
list affiliation, position on the list, nominating party, political affiliation,
number of preferential votes, and whether they were elected or held specific
positions (mayor, deputy mayor, member of the executive body).

The dataset also includes contextual election-level information, such as the
number of eligible voters and ballots cast, which can be used to calculate
voter turnout and related indicators. These variables appear only once per
election and constituency (they may be stored in a single candidate row for
that election/constituency)
}

\examples{
# Basic inspection
str(Horomerice_PZ_cz)

# Example of a basic continuity diagram (unformatted version)
\donttest{plot_continuity(Horomerice_PZ_cz, elections = "2010-")}
}
\references{
\itemize{
\item Vobecka, J., & Kostelecky, T. (Eds.) (2007). \emph{Politicke dusledky suburbanizace.}
(Political Consequences of Suburbanization). Prague: Institute of Sociology
of the Czech Academy of Sciences.
[\href{https://www.soc.cas.cz/images/drupal/publikace/259_ss_07_08.pdf}{Full text}]
\item Kadlecova, S. (2013). \emph{Lokalni stranicky system v obci Horomerice}
(Local Party System in the Municipality of Horomerice).
Bachelor thesis. Czech University of Life Sciences Prague.
[\href{https://theses.cz/id/9eylkt/?lang=en}{Full text}]
\item Maxa, D. (2024). \emph{Formovani organu mistni samospravy v obci Horomerice.}
(The process of Setting Up the Local Government in the Municipality of
Horomerice). Bachelor thesis. Czech University of Life Sciences Prague.
[\href{https://theses.cz/id/bfxe93/?lang=en}{Full text}]
\item Novakova, N. (2025). \emph{Politicke aspekty rizeni a rozvoje vybrane obce}
\emph{(pripadova studie obce Horomerice)} (Political Aspects of Management
and the Development of the Chosen Municipality (Case Study of Horomerice).
Bachelor thesis. Czech University of Life Sciences Prague.
[\href{https://theses.cz/id/2wmh4o/?lang=en}{Full text}]
}
}
\keyword{datasets}
