% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nslphom_dual.R
\name{nslphom_dual}
\alias{nslphom_dual}
\title{Implements the nslphom_dual algorithm}
\usage{
nslphom_dual(
  votes_election1,
  votes_election2,
  iter.max = 10,
  min.first = FALSE,
  integers = FALSE,
  solver = "lp_solve",
  integers.solver = "symphony",
  tol = 10^-5,
  ...
)
}
\arguments{
\item{votes_election1}{data.frame (or matrix) of order IxJ with the counts to be initially
mapped to rows. When estimating vote transfer matrices, the votes gained by
the \emph{J} political options competing on election 1 (or origin) in the \emph{I}
territorial units considered.  The sum by rows of \code{votes_election1} and
\code{votes_election2} must coincide.}

\item{votes_election2}{data.frame (or matrix) of order IxK with the counts to be initially mapped
to columns. When estimating vote transfer matrices, the votes gained by
the \emph{K} political options competing on election 2 (or destination) in the \emph{I}
territorial units considered. The sum by rows of \code{votes_election1} and
\code{votes_election2} must coincide.}

\item{iter.max}{Maximum number of iterations to be performed in each dual linear program.
The process ends independently in each system when either the number of iterations reaches
iter.max or when the maximum variation between two consecutive estimates of the
probability transfer matrix is less than \code{tol}. By default, 10.}

\item{min.first}{A \code{TRUE/FALSE} value. If \code{FALSE}, the matrix associated with the minimum \code{HETe} after
performing \code{iter.max} iterations is taken as solution.
If \code{TRUE}, the associated matrix to the instant in which the first decrease of \code{HETe} occurs
is taken as solution. The process stops at that moment. In this last scenario
(when \code{min.first = TRUE}), \code{iter.max} is is forced to be at least 100. Default, \code{FALSE}.}

\item{integers}{A \code{TRUE/FALSE} value that indicates whether the problem is solved in integer values in
each iteration: zero (lphom) and intermediate and final (including unit) solutions.
If \code{TRUE}, the initial LP matrices are approximated in each iteration to the closest integer solution
solving the corresponding Integer Linear Program. Default, \code{FALSE}.}

\item{solver}{A character string indicating the linear programming solver to be used, only
\code{lp_solve} and \code{symphony} are allowed. By default, \code{lp_solve}. The package \code{Rsymphony}
needs to be installed for the option \code{symphony} to be used.}

\item{integers.solver}{A character string indicating the linear programming solver to be used to approximate
to the closest integer solution, only \code{symphony} and \code{lp_solve} are allowed.
By default, \code{symphony}. The package \code{Rsymphony} needs to be installed for the option \code{symphony}
to be used. Only used when \code{integers = TRUE}.}

\item{tol}{Maximum deviation allowed between two consecutive iterations. The process ends when the maximum
variation between two proportions for the estimation of the transfer matrix between two consecutive
iterations is less than \code{tol} or the maximum number of iterations, \code{iter.max}, has been reached. By default, 0.00001.}

\item{...}{Other arguments to be passed to the function. Not currently used.}
}
\value{
A list with the following components
\item{VTM.votes.w}{ The matrix of order JxK with the estimated cross-distribution of votes of elections 1 and 2,
attained weighting the two dual solutions using as weights the corresponding HTEe estimates.}
\item{VTM.votes.units.w}{ The array of order JxKxI with the local estimated cross-distributions of votes of elections 1 and 2 by unit,
attained weighting the two dual solutions using as weights the corresponding HTEe estimates.}
\item{VTM.votes.a}{ The matrix of order JxK with the estimated cross-distribution of votes of elections 1 and 2,
attained simple averaging the two dual solutions.}
\item{VTM.votes.units.a}{ The matrix of order JxKxI with the estimated cross-distributions of votes of elections 1 and 2 by unit,
attained weighting the two dual solutions using as weights the corresponding HTEe estimates.}
\item{HETe.w}{ Estimated heterogeneity index associated to the \code{VTM.votes.w} solution.}
\item{HETe.a}{ Estimated heterogeneity index associated to the \code{VTM.votes.a} solution.}
\item{VTM12.w}{ The matrix of order JxK with the estimated row-standardized proportions of vote transitions from election 1
to election 2 associated to the \code{VTM.votes.w} solution.}
\item{VTM21.w}{ The matrix of order KxJ with the estimated row-standardized proportions of vote transitions from election 2
to election 1 associated to the \code{VTM.votes.w} solution.}
\item{VTM12.a}{ The matrix of order JxK with the estimated row-standardized proportions of vote transitions from election 1
to election 2 associated to the \code{VTM.votes.a} solution.}
\item{VTM21.a}{ The matrix of order KxJ with the estimated row-standardized proportions of vote transitions from election 2
to election 1 associated to the \code{VTM.votes.a} solution.}
\item{nslphom.object.12}{ The output of the \code{\link{nslphom}} function attained solving the problem X --> Y,
that is, mapping \code{votes_election1} to rows and \code{votes_election2} to columns.}
\item{nslphom.object.21}{ The output of the \code{\link{nslphom}} function attained solving the problem Y --> X,
that is, mapping \code{votes_election2} to rows and \code{votes_election1} to columns.}
\item{inputs}{ A list containing all the objects with the values used as arguments by the function.}
}
\description{
Estimates RxC vote transfer matrices (ecological contingency tables) with nslphom_dual
}
\examples{
x <- France2017P[, 1:8]
y <- France2017P[, 9:12]
y[,1] <- y[,1]  - (rowSums(y) - rowSums(x))
mt <- nslphom_dual(x, y)
mt$VTM.votes.w
mt$HETe.w

}
\references{
Pavia, JM and Romero, R (2024). Symmetry estimating RxC vote transfer matrices from aggregate data. \emph{Journal of the Royal Statistical Society, Series A – Statistics in Society}, 187(4), 919-943. \doi{10.1093/jrsssa/qnae013}
}
\seealso{
\code{\link{nslphom}} \code{\link{lphom_dual}} \code{\link{tslphom_dual}} \code{\link{lphom_joint}} \code{\link{tslphom_joint}} \code{\link{nslphom_joint}}

Other linear programing ecological inference functions: 
\code{\link{lclphom}()},
\code{\link{lp_apriori}()},
\code{\link{lphom_dual}()},
\code{\link{lphom_joint}()},
\code{\link{lphom}()},
\code{\link{nslphom_joint}()},
\code{\link{nslphom}()},
\code{\link{rslphom}()},
\code{\link{tslphom_dual}()},
\code{\link{tslphom_joint}()},
\code{\link{tslphom}()}
}
\author{
Jose M. Pavia, \email{pavia@uv.es}

Rafael Romero \email{rromero@eio.upv.es}
}
\concept{linear programing ecological inference functions}
