% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/followingRelation.R
\name{followingRelation}
\alias{followingRelation}
\title{followingRelation}
\usage{
followingRelation(Y, X, timeLagWindow, lagWindow = 0.1)
}
\arguments{
\item{Y}{is a T-by-D matrix of numerical time series of a follower}

\item{X}{is a T-by-D matrix numerical time series of a leader}

\item{timeLagWindow}{is a maximum possible time delay in the term of time steps.}

\item{lagWindow}{is a maximum possible time delay in the term of percentage of length(X).
If \code{timeLagWindow} is missing, then \code{timeLagWindow=ceiling(lagWindow*length(X))}. The default is 0.2.}
}
\value{
This function returns a list of following relation variables below.

\item{follVal}{ is a following-relation value s.t. if \code{follVal} is positive, then \code{Y} follows \code{X}. If  \code{follVal} is negative, then \code{X} follows \code{Y}.
Otherwise, if \code{follVal} is zero, there is no following relation between \code{X,Y}. }
\item{dtwIndexVec}{ is a numeric vector of index-warping difference: dtwIndexVec[k] = dtwOut$index1[k] - dtwOut$index2[k] where dtwOut is the output from dtw::dtw(x=Y,y=X) function.}
}
\description{
03/24/2021: Chai's code rewritten by Namrata to replicate Matlab version
The changes are in the DTW function, which is implemented here as DTW2 instead of the one in
the R package DTW

followingRelation is a function that infers whether \code{Y} follows \code{X}.
}
\examples{
# Load example data ???

leader<- mFLICA::TS[1,1:200,]
follower<- mFLICA::TS[2,1:200,]

# Run the function

out<-followingRelation(Y=follower,X=leader)

}
