% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dictionaries_functions.R
\name{data_dict_expand}
\alias{data_dict_expand}
\title{Transform single-row category information to multiple rows as element}
\usage{
data_dict_expand(
  data_dict,
  from = "Variables",
  name_prefix = "Categories::",
  to = "Categories"
)
}
\arguments{
\item{data_dict}{A list of data frame(s) representing metadata to be
transformed.}

\item{from}{A symbol identifying the name of the element (data frame) to take
column(s) from. Default is 'Variables'.}

\item{name_prefix}{Character string of the prefix of columns of interest.
This prefix will be used to select columns, and to rename them in the 'to'
element. Default is 'Categories::'.}

\item{to}{A symbol identifying the name of the element (data frame) to create
column(s) to. Default is 'Categories'.}
}
\value{
A list of data frame(s) identifying a data dictionary.
}
\description{
Expands data dictionary column(s) in a element (the parameter 'from'),
into another element (the parameter 'to').
If the element \code{from} contains any column starting with 'prefix', (xx,yy),
these columns will be added as 'xx' and 'yy' in the element identified by
\code{to}. This data frame will be created if necessary, and columns will be
added, from left to right. (unique names will be generated if necessary).
Separator of each element is the following structure :
'name = xx1 ; name = xx2'.
This function is mainly used to expand the column(s) 'Categories::xx' in
"Variables" to "Categories" element with column(s) xx.
This function is the reversed operation of \code{\link[=data_dict_collapse]{data_dict_collapse()}}
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.
}
\examples{
{

library(dplyr)

# use madshapR_examples provided by the package
data_dict_collapsed <- madshapR_examples$`data_dictionary_example - collapsed`

data_dict_expanded <- data_dict_expand(data_dict_collapsed)
glimpse(data_dict_expand(data_dict_expanded))

}

}
\seealso{
\code{\link[=data_dict_collapse]{data_dict_collapse()}}
}
