% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{ison_physicians}
\alias{ison_physicians}
\title{Four multiplex one-mode physician diffusion data (Coleman, Katz, and Menzel, 1966)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> $Peoria
#> # A multiplex, directed network of 117 nodes and 242 advice, 154 discussion,
#> and 147 friendship ties
#> 
#> -- Nodes
#> # A tibble: 117 x 12
#>   adoption specialty    conferences journals practice   community patients
#>      <dbl> <chr>        <chr>          <dbl> <chr>      <chr>     <chr>   
#> 1        1 Pediatrician Specialty          9 1920..1929 20+yrs    101-150 
#> 2       12 GP           None               5 1945..     -1yr      76-100  
#> 3        8 Internist    General            7 1935..1939 10-20yrs  76-100  
#> 4        9 GP           General            6 1940..1944 5-10yrs   51-75   
#> 5        9 GP           General            4 1935..1939 10-20yrs  51-75   
#> 6       10 Internist    None               7 1930..1934 10-20yrs  101-150 
#> # i 111 more rows
#> # i 5 more variables: doc_freetime <dbl>, doc_discuss <dbl>, doc_friends <dbl>,
#> #   doc_club <dbl>, doc_proximity <chr>
#> 
#> -- Ties
#> # A tibble: 543 x 3
#>    from    to type      
#>   <int> <int> <chr>     
#> 1     1     8 friendship
#> 2     1    58 friendship
#> 3     1    87 advice    
#> 4     1    90 advice    
#> 5     1   110 advice    
#> 6     1   112 friendship
#> # i 537 more rows
#> 
#> 
#> $Bloomington
#> # A multiplex, directed network of 50 nodes and 94 advice, 57 discussion, and
#> 60 friendship ties
#> 
#> -- Nodes
#> # A tibble: 50 x 12
#>   adoption specialty conferences journals practice   community patients
#>      <dbl> <chr>     <chr>          <dbl> <chr>      <chr>     <chr>   
#> 1       98 Internist Specialty          8 1930..1934 10-20yrs  101-150 
#> 2        1 GP        General            3 1945..     5-10yrs   76-100  
#> 3       98 GP        Specialty          4 1930..1934 10-20yrs  101-150 
#> 4        7 Internist None               3 1945..     -1yr      26-50   
#> 5        6 Internist General            9 1935..1939 5-10yrs   76-100  
#> 6        1 GP        Specialty          5 1935..1939 10-20yrs  101-150 
#> # i 44 more rows
#> # i 5 more variables: doc_freetime <dbl>, doc_discuss <dbl>, doc_friends <dbl>,
#> #   doc_club <dbl>, doc_proximity <chr>
#> 
#> -- Ties
#> # A tibble: 211 x 3
#>    from    to type      
#>   <int> <int> <chr>     
#> 1     1     3 friendship
#> 2     1    10 discussion
#> 3     1    24 advice    
#> 4     1    44 advice    
#> 5     2     4 advice    
#> 6     2     6 advice    
#> # i 205 more rows
#> 
#> 
#> $Quincy
#> # A multiplex, directed network of 44 nodes and 70 advice, 52 discussion, and
#> 52 friendship ties
#> 
#> -- Nodes
#> # A tibble: 44 x 12
#>   adoption specialty conferences journals practice   community patients
#>      <dbl> <chr>     <chr>          <dbl> <chr>      <chr>     <chr>   
#> 1        2 Internist None               6 1935..1939 10-20yrs  151+    
#> 2       18 GP        General            3 1920..1929 20+yrs    151+    
#> 3       18 Internist None               5 1945..     -1yr      -25     
#> 4        4 GP        General            3 1930..1934 20+yrs    151+    
#> 5       18 GP        Specialty          4 1935..1939 10-20yrs  151+    
#> 6        5 Internist General            5 ..1919     20+yrs    51-75   
#> # i 38 more rows
#> # i 5 more variables: doc_freetime <dbl>, doc_discuss <dbl>, doc_friends <dbl>,
#> #   doc_club <dbl>, doc_proximity <chr>
#> 
#> -- Ties
#> # A tibble: 174 x 3
#>    from    to type      
#>   <int> <int> <chr>     
#> 1     1     8 advice    
#> 2     1     9 advice    
#> 3     1    10 discussion
#> 4     1    13 friendship
#> 5     1    15 advice    
#> 6     1    22 discussion
#> # i 168 more rows
#> 
#> 
#> $Galesburg
#> # A multiplex, directed network of 35 nodes and 74 advice, 46 discussion, and
#> 51 friendship ties
#> 
#> -- Nodes
#> # A tibble: 35 x 12
#>   adoption specialty conferences journals practice   community patients
#>      <dbl> <chr>     <chr>          <dbl> <chr>      <chr>     <chr>   
#> 1       18 GP        General            4 1935..1939 5-10yrs   101-150 
#> 2       18 GP        None               4 1935..1939 -1yr      151+    
#> 3        4 GP        General            6 1945..     2-5yrs    51-75   
#> 4        5 GP        None               4 1935..1939 10-20yrs  101-150 
#> 5        8 Internist General            6 1935..1939 5-10yrs   151+    
#> 6        4 Internist Specialty          8 ..1919     20+yrs    76-100  
#> # i 29 more rows
#> # i 5 more variables: doc_freetime <dbl>, doc_discuss <dbl>, doc_friends <dbl>,
#> #   doc_club <dbl>, doc_proximity <chr>
#> 
#> -- Ties
#> # A tibble: 171 x 3
#>    from    to type      
#>   <int> <int> <chr>     
#> 1     1     5 advice    
#> 2     1     6 advice    
#> 3     1    20 discussion
#> 4     1    23 discussion
#> 5     1    30 friendship
#> 6     1    31 friendship
#> # i 165 more rows
#> 
}\if{html}{\out{</div>}}
}
\source{
\code{{networkdata}}
}
\usage{
data(ison_physicians)
}
\description{
Ron Burt prepared this data from
Coleman, Katz and Menzel's 1966 study on medical innovation.
They had collected data from physicians in four towns in Illinois:
Peoria, Bloomington, Quincy and Galesburg.
These four networks are held as separate networks in a list.

Coleman, Katz and Menzel were concerned with the impact of network ties
on the physicians' adoption of a new drug, tetracycline.
Data on three types of ties were collected in response to three questions:
\itemize{
\item advice: "When you need information or advice about questions of therapy
where do you usually turn?"
\item discussion: "And who are the three or four physicians with whom you most often find yourself
discussing cases or therapy in the course of an ordinary week – last week for instance?"
\item friendship: "Would you tell me the first names of your three friends
whom you see most often socially?"
}

Additional questions and records of prescriptions provided additional information:
\itemize{
\item recorded date of tetracycline \code{adoption} date
\item years in \code{practice}
(note that these are \code{{messydates}}-compatible dates)
\item \code{conferences} attended
(those that attended "Specialty" conferences presumably also attended "General" conferences)
\item regular subscriptions to medical \code{journals}
\item \code{free_time} spent associating with doctors
\item \code{discussions} on medical matters when with other doctors sociallyy
\item memberships in \code{clubs} with other doctores
\item number of top 3 \code{friends} that are doctors
\item time practicing in current \code{community}
\item \code{patients} load (ordinal)
\item physical \code{proximity} to other physicians (in building/sharing office)
\item medical \code{specialty} (GP/Internist/Pediatrician/Other)
}
}
\references{
Coleman, James, Elihu Katz, and Herbert Menzel. 1966.
\emph{Medical innovation: A diffusion study}.
Indianapolis: The Bobbs-Merrill Company.
}
\keyword{datasets}
