% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layer_bitmap.R
\name{add_bitmap}
\alias{add_bitmap}
\title{Add bitmap}
\usage{
add_bitmap(
  map,
  image,
  bounds,
  desaturate = 0,
  transparent_colour = "#000000",
  tint_colour = "#FFFFFF",
  layer_id = NULL,
  update_view = TRUE,
  focus_layer = FALSE
)
}
\arguments{
\item{map}{a mapdeck map object}

\item{image}{url to an image to use on the map}

\item{bounds}{coordinates of the bounding box of the image [left, bottom, right, top]}

\item{desaturate}{the desatruation of the bitmap, in range [0,1], 0 being the original colour
and 1 being greyscale}

\item{transparent_colour}{the colour to use for transparent pixels as a hex string}

\item{tint_colour}{the colour to tint the bipmap by, as a hex string}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type. Layers with the same id are likely
to conflict and not plot correctly}

\item{update_view}{logical indicating if the map should update the bounds to include this layer}

\item{focus_layer}{logical indicating if the map should update the bounds to only include this layer}
}
\description{
Adds an image to a map
}
\examples{
\donttest{

set_token( "MAPBOX_TOKEN" )

mapdeck(location = c(-122.3, 37.8), zoom = 10) \%>\%
 add_bitmap(
   image = paste0(
   'https://raw.githubusercontent.com/uber-common/deck.gl-data/master/',
   'website/sf-districts.png')
   , bounds = c(-122.519, 37.7045, -122.355, 37.829)
 )

mapdeck(location = c(-75.9, 40.9), zoom = 4) \%>\%
  add_bitmap(
    image = 'https://docs.mapbox.com/mapbox-gl-js/assets/radar.gif'
    , bounds = c(-80.425, 37.936, -71.516, 46.437)
  )

mapdeck(location = c(-75.9, 40.9), zoom = 4) \%>\%
  add_bitmap(
    image = 'https://docs.mapbox.com/mapbox-gl-js/assets/radar.gif'
    , bounds = c(-80.425, 37.936, -71.516, 46.437)
    , tint_colour = "#FF0000"
  )

mapdeck(location = c(-75.9, 40.9), zoom = 4) \%>\%
  add_bitmap(
    image = 'https://docs.mapbox.com/mapbox-gl-js/assets/radar.gif'
    , bounds = c(-80.425, 37.936, -71.516, 46.437)
    , desaturate = 1
  )

}

}
