% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{available_models}
\alias{available_models}
\title{Available Models Table}
\format{
\subsection{\code{available_models}}{

A data.frame/tibble with 13 rows and 6 columns:

\describe{

\item{model_name}{Model name to be used within \code{\link[=fit_devmodels]{fit_devmodels()}}.}

\item{package}{names of the packages used by \code{\link[=fit_devmodels]{fit_devmodels()}} to obtain
appropriate start values for the user-provided data.
When the package is \if{html}{\out{<a href="https://padpadpadpad.github.io/rTPC/">}}rTPC package\if{html}{\out{</a>}},
start values are automatically computed with \code{\link[rTPC:get_start_vals]{rTPC::get_start_vals()}},
which in turn relies on \code{\link[nls.multstart:nls_multstart]{nls.multstart::nls_multstart()}}.
When the package is \if{html}{\out{<a href="https://github.com/frareb/devRate">}}devRate package\if{html}{\out{</a>}},
iterative starting values are computed using \code{\link[nls.multstart:nls_multstart]{nls.multstart::nls_multstart()}},
using the parameters published in \code{\link[devRate:devRateEqStartVal]{devRate::devRateEqStartVal()}}
as first attempts to iterate.
As an exception, if \code{model_name == "briere1"}, generic starting values are provided
and advised to the user due to the unrealistic value of some parameters in the
\code{devRate} data set.}

\item{source_model_name}{name of the function in the source packages \code{rTPC} and \code{devRate}.}

\item{formula, working_formula, n_params}{formulas used for model fitting.}
}
}
}
\source{
Rebaudo, F., Struelens, Q., and Dangles, O. (2018). Modelling temperature-dependent
development rate and phenology in arthropods: The \code{devRate} package for R.
Methods Ecol Evol. 9: 1144-1150. \doi{10.1111/2041-210X.12935}.

Padfield, D., O´Sullivan, H., and Pawar, S., (2021). \code{rTPC} and \code{nls.multstart}:
a new pipeline to fit thermal performance curves in R. Methods Ecol Evol. 12: 1138-1143.
\doi{10.1111/2041-210X.13585}.
}
\usage{
data("available_models")
}
\description{
Table containing the available models to be fit using \code{\link[=fit_devmodels]{fit_devmodels()}}.
These models come from two other packages:
\if{html}{\out{<a href="https://cran.r-project.org/package=devRate">}}\code{devRate} \if{html}{\out{</a>}} and
\if{html}{\out{<a href="https://padpadpadpad.github.io/rTPC/">}}\code{rTPC} \if{html}{\out{</a>}}.
}
\keyword{datasets}
