% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_get_ratio.R
\name{mf_get_ratio}
\alias{mf_get_ratio}
\title{Get map width and height values}
\usage{
mf_get_ratio(x, width, height, expandBB = rep(0, 4), theme = mf_theme())
}
\arguments{
\item{x}{object of class \code{sf}, \code{sfc} or \code{SpatRaster}}

\item{width}{width of the figure (inches), use only one of width or height}

\item{height}{height of the figure (inches), use only one of width or height}

\item{expandBB}{fractional values to expand the bounding box with, in each
direction (bottom, left, top, right)}

\item{theme}{theme used for the map}
}
\value{
Width and height are returned in inches.
}
\description{
This function is to be used to get width and height values
for maps created in reports (*.Rmd, *.qmd).\cr
It uses the width / height ratio of a spatial object bounding box to find a
matching ratio for the map.\cr
If width is specified, then height is deduced from the width / height ratio
of x, figure margins and title size.\cr
If height is specified, then width is
deduced from the width / height ratio of x, figure margins and title size.
}
\examples{
mtq <- mf_get_mtq()
mf_get_ratio(x = mtq, width = 5)
}
