% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marcox.R
\name{marcox}
\alias{marcox}
\title{Analysis for Cox Proportional Hazards Models}
\usage{
marcox(
  formula,
  data,
  method = "exchangeable",
  sep = NULL,
  col_id = "id",
  div = NULL,
  k_value = 1,
  plot_x = NULL,
  x_axis = "Time",
  y_axis = "Survival Rates",
  size = 0.5
)
}
\arguments{
\item{formula}{A model formula that uses the \code{Surv()} function to define the survival outcome. It should include
both continuous and categorical covariates, where categorical variables must be specified using the \code{factormar()} function.}

\item{data}{The file path or the dataset(matrix) to be analyzed. If a file path is provided, the file will be loaded into a matrix.
The file should be in a tabular format (e.g., .csv, .txt).}

\item{method}{The method employed to solve the correlation coefficient:
\itemize{
\item Exchangeable correlation structure: \code{method = 'exchangeable'}
\item Autoregressive(AR-1): \code{method = 'ar1'}
\item K-dependent: \code{method = 'kdependent'}
\item Toeplitz: \code{method = 'toeplitz'}
\item Independent: \code{method = 'independent'}
}}

\item{sep}{Character. The \code{sep} parameter specifies the character that separates
the fields in each line of the file. For instance, for a comma-separated file, set \code{sep = ","},
and for a tab-separated file, set \code{sep = "\t"}.}

\item{col_id}{Character. The name of column that identifies the clusters.}

\item{div}{Integer. The number of observation points per sample. If provided, the data will be divided accordingly.
If the data has complex observational situations, please preprocess the data before using this function.}

\item{k_value}{The k value only for k-dependent structure. The default value is 1.}

\item{plot_x}{A character string specifying the column name of the covariate for which survival curves are generated; if not provided, no survival curves will be produced.}

\item{x_axis}{A character string specifying the title for the x-axis.}

\item{y_axis}{A character string specifying the title for the y-axis.}

\item{size}{The size of the generated survival curve.}
}
\value{
A list containing the following components:
\itemize{
\item \code{coef} - The estimated regression coefficients.
\item \code{exp(coef)} - The exponentiated coefficients (hazard ratios).
\item \code{se(coef)} - The standard errors of the estimated coefficients.
\item \code{z} - The z-statistics for testing the significance of the coefficients.
\item \code{p} - The p-values associated with the coefficients.
\item (hidden).correlation - Correlation coefficients of the data.
}
}
\description{
This function performs marcox analysis for Cox proportional hazards models, incorporating clustered data
and handling time-dependent covariates. It estimates coefficients, standard errors, and p-values based on
the specified formula and dataset.
}
\details{
The \code{marcox()} function is specifically designed for survival data analysis using Cox proportional hazards models. It handles both clustered and time-dependent covariates effectively.
The survival outcome must be defined using the \code{Surv()} function in the model formula, and covariates can be included directly or by converting categorical variables with the \code{factormar()} function.
}
\examples{
  formula <- Surv(time, cens) ~ sex + factormar('type', d_v=c(1,2,3))
  r <- marcox(formula, data = kidney_data, div = 2, method = 'exchangeable', plot_x = 'sex')
  print(r)
  print(r$plot)
}
