
prep_data <- function(data, studyID, samp_size_name, variable_names = NULL) {

  if(is.data.frame(data)) {
    data_matrix <- df_to_corr(data, variables = variable_names, ID = studyID)
  }

  data_vector_list <- lapply(data_matrix,  corpcor::sm2vec)
  data_vector <-   matrix(unlist(data_vector_list))

  study <- rep(data[[studyID]], each = length(data_vector_list[[1]]))
  N <- rep(data[[samp_size_name]], each = length(data_vector_list[[1]]))

  if(!is.null(variable_names)) {
    var_names <- data.frame(t(combn(colnames(data_matrix[[1]]), 2)))
    names(var_names) <- c('Variable1', 'Variable2')
    var_names[['numID']] <- 1:nrow(var_names)
    } else {
    var_names <- NULL
    }

  outcome <- unlist(lapply(1:nrow(var_names), function(xx)
    paste(var_names[xx, ], collapse = "_")))
  outcome <- rep(outcome, nrow(data))

  var_names <- do.call("rbind",
                       replicate(nrow(data),
                                 var_names, simplify = FALSE))

  cbind(var_names,
                    data.frame(ri = data_vector,
                         outcome = outcome,
                         study = study,
                         N = N
  ))
}
