% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/declination.R
\name{declination}
\alias{declination}
\title{Solar declination angle on Mars}
\usage{
declination(Ls, unit = 1)
}
\arguments{
\item{Ls}{Areocentric longitude [deg]}

\item{unit}{Output unit: 1 for radians, 2 for degrees (default: 1)}
}
\value{
Declination angle [rad] or [deg] depending on unit parameter
}
\description{
Calculates the angular position of the Sun at solar noon with respect to the plane of the
Martian equator. For Mars: -24.936° <= delta <= 24.936°. The declination is 0° at vernal
(Ls=0°) and autumnal equinoxes (Ls=180°), +24.936° at summer solstice (Ls=90°), and -24.936°
at winter solstice (Ls=270°). Implements Equation 7 from Appelbaum & Flood (1990).
}
