% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_matrix.R
\name{init_matrix}
\alias{init_matrix}
\title{Initialize a Literature Review Matrix}
\usage{
init_matrix(...)
}
\arguments{
\item{...}{Optional. Additional column names (as character strings) to be appended to the matrix.}
}
\value{
A data frame with predefined columns for literature review analysis.
}
\description{
Creates a standardized data frame for systematic literature review with predefined columns,
allowing the addition of custom columns if needed.
}
\details{
The matrix includes the following predefined columns:
- `year`: Numeric. Year of publication.
- `citation`: Character. Citation or reference details.
- `keywords`: Character. Keywords or tags for the study.
- `profession`: Character. Profession of the study participants or target audience.
- `electronic`: Logical. Indicates whether the study is available electronically.
- `purpose`: Character. Purpose or objective of the study.
- `study_design`: Character. Study design or methodology.
- `outcome_var`: Character. Outcome variables measured in the study.
- `predictor_var`: Character. Predictor variables considered in the study.
- `sample`: Numeric. Sample size.
- `dropout_rate`: Numeric. Dropout or attrition rate.
- `setting`: Character. Study setting (e.g., clinical, educational).
- `inclusion_criteria`: Character. Inclusion criteria for participants.
- `ethnicity`: Character. Ethnic background of participants.
- `age`: Numeric. Age of participants.
- `sex`: Factor. Sex of participants.
- `income`: Factor. Income level of participants.
- `education`: Character. Educational background of participants.
- `measures`: Character. Measures or instruments used for data collection.
- `analysis`: Character. Analytical methods used.
- `results`: Character. Summary of results or findings.
- `limitations`: Character. Limitations of the study.
- `implications`: Character. Implications or recommendations from the study.
- `ethical_concerns`: Character. Ethical concerns addressed in the study.
- `biases`: Character. Potential biases in the study.
- `notes`: Character. Additional notes or observations.

Custom columns can also be added by passing their names via the `...` argument.
}
\examples{
# Create a basic literature review matrix
lit_matrix <- init_matrix()


}
